package ru.yandex.autotests.directapi.retargetinglists.update;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.*;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.UPDATE)
@Description("Валидация JSON-запроса при добавлении")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class UpdateRetargetingListsJsonValidationTest {
    private static long correctGoalId;
    private static String INVALID_FIELD = "invalidField";
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING14;
    private static Long id;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        correctGoalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        id = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(correctGoalId);
    }

    @Test
    public void arrayInId(){
        JSONObject request = new JSONObject();
        JSONObject retargetingLists = new JSONObject();
        JSONObject rules = new JSONObject();
        JSONObject arguments = new JSONObject();
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.MEMBERSHIP_LIFE_SPAN), 30);
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.EXTERNAL_ID), correctGoalId);
        rules.put(capitalize(RetargetingListRuleItemMap.ARGUMENTS), new Object[]{arguments});
        rules.put(capitalize(RetargetingListRuleItemMap.OPERATOR), RetargetingListRuleOperatorEnum.ANY);
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.RULES), new Object[]{rules});
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.NAME), "Name");
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.DESCRIPTION), "Description");
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.ID), new Long[]{id});
        request.put(capitalize(UpdateRequestMap.RETARGETING_LISTS), new Object[]{retargetingLists});
        api.userSteps.retargetingListsSteps().shouldGetJSONErrorOn(
                ServiceNames.RETARGETING_LISTS,
                LOGIN,
                Action.UPDATE,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(UpdateRequestMap.RETARGETING_LISTS, RetargetingListUpdateItemMap.ID)));
    }

    @Test
    public void notArrayRetargetingLists(){
        JSONObject request = new JSONObject();
        JSONObject retargetingLists = new JSONObject();
        JSONObject rules = new JSONObject();
        JSONObject arguments = new JSONObject();
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.MEMBERSHIP_LIFE_SPAN), 30);
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.EXTERNAL_ID), correctGoalId);
        rules.put(capitalize(RetargetingListRuleItemMap.ARGUMENTS), new Object[]{arguments});
        rules.put(capitalize(RetargetingListRuleItemMap.OPERATOR), RetargetingListRuleOperatorEnum.ANY);
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.RULES), new Object[]{rules});
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.NAME), "Name");
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.DESCRIPTION), "Description");
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.ID), id);
        request.put(capitalize(UpdateRequestMap.RETARGETING_LISTS), retargetingLists);
        api.userSteps.retargetingListsSteps().shouldGetJSONErrorOn(
                ServiceNames.RETARGETING_LISTS,
                LOGIN,
                Action.UPDATE,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(UpdateRequestMap.RETARGETING_LISTS)));
    }

    @Test
    public void invalidFieldInRetargetingLists(){
        JSONObject request = new JSONObject();
        JSONObject retargetingLists = new JSONObject();
        JSONObject rules = new JSONObject();
        JSONObject arguments = new JSONObject();
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.MEMBERSHIP_LIFE_SPAN), 30);
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.EXTERNAL_ID), correctGoalId);
        rules.put(capitalize(RetargetingListRuleItemMap.ARGUMENTS), new Object[]{arguments});
        rules.put(capitalize(RetargetingListRuleItemMap.OPERATOR), RetargetingListRuleOperatorEnum.ANY);
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.RULES), new Object[]{rules});
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.NAME), "Name");
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.DESCRIPTION), "Description");
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.ID), id);
        retargetingLists.put(INVALID_FIELD, INVALID_FIELD);
        request.put(capitalize(UpdateRequestMap.RETARGETING_LISTS), new Object[]{retargetingLists});
        api.userSteps.retargetingListsSteps().shouldGetJSONErrorOn(
                ServiceNames.RETARGETING_LISTS,
                LOGIN,
                Action.UPDATE,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAIN_UNKNOWN_FIELD,
                        path(UpdateRequestMap.RETARGETING_LISTS), INVALID_FIELD));
    }

    @Test
    public void arrayInName(){
        JSONObject request = new JSONObject();
        JSONObject retargetingLists = new JSONObject();
        JSONObject rules = new JSONObject();
        JSONObject arguments = new JSONObject();
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.MEMBERSHIP_LIFE_SPAN), 30);
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.EXTERNAL_ID), correctGoalId);
        rules.put(capitalize(RetargetingListRuleItemMap.ARGUMENTS), new Object[]{arguments});
        rules.put(capitalize(RetargetingListRuleItemMap.OPERATOR), RetargetingListRuleOperatorEnum.ANY);
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.RULES), new Object[]{rules});
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.NAME), new Object[]{"Name"});
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.DESCRIPTION), "Description");
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.ID), id);
        request.put(capitalize(UpdateRequestMap.RETARGETING_LISTS), new Object[]{retargetingLists});
        api.userSteps.retargetingListsSteps().shouldGetJSONErrorOn(
                ServiceNames.RETARGETING_LISTS,
                LOGIN,
                Action.UPDATE,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(UpdateRequestMap.RETARGETING_LISTS, RetargetingListUpdateItemMap.NAME)));
    }

    @Test
    public void arrayInDescription(){
        JSONObject request = new JSONObject();
        JSONObject retargetingLists = new JSONObject();
        JSONObject rules = new JSONObject();
        JSONObject arguments = new JSONObject();
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.MEMBERSHIP_LIFE_SPAN), 30);
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.EXTERNAL_ID), correctGoalId);
        rules.put(capitalize(RetargetingListRuleItemMap.ARGUMENTS), new Object[]{arguments});
        rules.put(capitalize(RetargetingListRuleItemMap.OPERATOR), RetargetingListRuleOperatorEnum.ANY);
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.RULES), new Object[]{rules});
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.NAME), "Name");
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.DESCRIPTION), new Object[]{"Description"});
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.ID), id);
        request.put(capitalize(UpdateRequestMap.RETARGETING_LISTS), new Object[]{retargetingLists});
        api.userSteps.retargetingListsSteps().shouldGetJSONErrorOn(
                ServiceNames.RETARGETING_LISTS,
                LOGIN,
                Action.UPDATE,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(UpdateRequestMap.RETARGETING_LISTS, RetargetingListUpdateItemMap.DESCRIPTION)));
    }

    @Test
    public void notArrayInRules(){
        JSONObject request = new JSONObject();
        JSONObject retargetingLists = new JSONObject();
        JSONObject rules = new JSONObject();
        JSONObject arguments = new JSONObject();
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.MEMBERSHIP_LIFE_SPAN), 30);
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.EXTERNAL_ID), correctGoalId);
        rules.put(capitalize(RetargetingListRuleItemMap.ARGUMENTS), new Object[]{arguments});
        rules.put(capitalize(RetargetingListRuleItemMap.OPERATOR), RetargetingListRuleOperatorEnum.ANY);
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.RULES), rules);
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.NAME), "Name");
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.DESCRIPTION), "Description");
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.ID), id);
        request.put(capitalize(UpdateRequestMap.RETARGETING_LISTS), new Object[]{retargetingLists});
        api.userSteps.retargetingListsSteps().shouldGetJSONErrorOn(
                ServiceNames.RETARGETING_LISTS,
                LOGIN,
                Action.UPDATE,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(UpdateRequestMap.RETARGETING_LISTS, RetargetingListUpdateItemMap.RULES)));
    }

    @Test
    public void invalidFieldInRules(){
        JSONObject request = new JSONObject();
        JSONObject retargetingLists = new JSONObject();
        JSONObject rules = new JSONObject();
        JSONObject arguments = new JSONObject();
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.MEMBERSHIP_LIFE_SPAN), 30);
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.EXTERNAL_ID), correctGoalId);
        rules.put(capitalize(RetargetingListRuleItemMap.ARGUMENTS), new Object[]{arguments});
        rules.put(capitalize(RetargetingListRuleItemMap.OPERATOR), RetargetingListRuleOperatorEnum.ANY);
        rules.put(INVALID_FIELD, INVALID_FIELD);
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.RULES), new Object[]{rules});
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.NAME), "Name");
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.DESCRIPTION), "Description");
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.ID), id);
        request.put(capitalize(UpdateRequestMap.RETARGETING_LISTS), new Object[]{retargetingLists});
        api.userSteps.retargetingListsSteps().shouldGetJSONErrorOn(
                ServiceNames.RETARGETING_LISTS,
                LOGIN,
                Action.UPDATE,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAIN_UNKNOWN_FIELD,
                        path(UpdateRequestMap.RETARGETING_LISTS, RetargetingListUpdateItemMap.RULES),
                                INVALID_FIELD));
    }

    @Test
    public void arrayInOperatorField(){
        JSONObject request = new JSONObject();
        JSONObject retargetingLists = new JSONObject();
        JSONObject rules = new JSONObject();
        JSONObject arguments = new JSONObject();
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.MEMBERSHIP_LIFE_SPAN), 30);
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.EXTERNAL_ID), correctGoalId);
        rules.put(capitalize(RetargetingListRuleItemMap.ARGUMENTS), new Object[]{arguments});
        rules.put(capitalize(RetargetingListRuleItemMap.OPERATOR), new Object[]{RetargetingListRuleOperatorEnum.ANY});
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.RULES), new Object[]{rules});
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.NAME), "Name");
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.DESCRIPTION), "Description");
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.ID), id);
        request.put(capitalize(UpdateRequestMap.RETARGETING_LISTS), new Object[]{retargetingLists});
        api.userSteps.retargetingListsSteps().shouldGetJSONErrorOn(
                ServiceNames.RETARGETING_LISTS,
                LOGIN,
                Action.UPDATE,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(UpdateRequestMap.RETARGETING_LISTS,
                                RetargetingListUpdateItemMap.RULES,
                                RetargetingListRuleItemMap.OPERATOR)));
    }

    @Test
    public void notArrayInArgumentsField(){
        JSONObject request = new JSONObject();
        JSONObject retargetingLists = new JSONObject();
        JSONObject rules = new JSONObject();
        JSONObject arguments = new JSONObject();
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.MEMBERSHIP_LIFE_SPAN), 30);
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.EXTERNAL_ID), correctGoalId);
        rules.put(capitalize(RetargetingListRuleItemMap.ARGUMENTS), arguments);
        rules.put(capitalize(RetargetingListRuleItemMap.OPERATOR), RetargetingListRuleOperatorEnum.ANY);
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.RULES), new Object[]{rules});
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.NAME), "Name");
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.DESCRIPTION), "Description");
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.ID), id);
        request.put(capitalize(UpdateRequestMap.RETARGETING_LISTS), new Object[]{retargetingLists});
        api.userSteps.retargetingListsSteps().shouldGetJSONErrorOn(
                ServiceNames.RETARGETING_LISTS,
                LOGIN,
                Action.UPDATE,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(UpdateRequestMap.RETARGETING_LISTS,
                                RetargetingListUpdateItemMap.RULES,
                                RetargetingListRuleItemMap.ARGUMENTS)));
    }

    @Test
    public void invalidFieldInArgumentsField(){
        JSONObject request = new JSONObject();
        JSONObject retargetingLists = new JSONObject();
        JSONObject rules = new JSONObject();
        JSONObject arguments = new JSONObject();
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.MEMBERSHIP_LIFE_SPAN), 30);
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.EXTERNAL_ID), correctGoalId);
        arguments.put(INVALID_FIELD, INVALID_FIELD);
        rules.put(capitalize(RetargetingListRuleItemMap.ARGUMENTS), new Object[]{arguments});
        rules.put(capitalize(RetargetingListRuleItemMap.OPERATOR), RetargetingListRuleOperatorEnum.ANY);
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.RULES), new Object[]{rules});
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.NAME), "Name");
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.DESCRIPTION), "Description");
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.ID), id);
        request.put(capitalize(UpdateRequestMap.RETARGETING_LISTS), new Object[]{retargetingLists});
        api.userSteps.retargetingListsSteps().shouldGetJSONErrorOn(
                ServiceNames.RETARGETING_LISTS,
                LOGIN,
                Action.UPDATE,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAIN_UNKNOWN_FIELD,
                        path(UpdateRequestMap.RETARGETING_LISTS,
                                RetargetingListUpdateItemMap.RULES,
                                RetargetingListRuleItemMap.ARGUMENTS), INVALID_FIELD));
    }

    @Test
    public void arrayInLifespanField(){
        JSONObject request = new JSONObject();
        JSONObject retargetingLists = new JSONObject();
        JSONObject rules = new JSONObject();
        JSONObject arguments = new JSONObject();
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.MEMBERSHIP_LIFE_SPAN), new Object[]{30});
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.EXTERNAL_ID), correctGoalId);
        rules.put(capitalize(RetargetingListRuleItemMap.ARGUMENTS), new Object[]{arguments});
        rules.put(capitalize(RetargetingListRuleItemMap.OPERATOR), RetargetingListRuleOperatorEnum.ANY);
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.RULES), new Object[]{rules});
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.NAME), "Name");
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.DESCRIPTION), "Description");
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.ID), id);
        request.put(capitalize(UpdateRequestMap.RETARGETING_LISTS), new Object[]{retargetingLists});
        api.userSteps.retargetingListsSteps().shouldGetJSONErrorOn(
                ServiceNames.RETARGETING_LISTS,
                LOGIN,
                Action.UPDATE,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(UpdateRequestMap.RETARGETING_LISTS,
                                RetargetingListUpdateItemMap.RULES,
                                RetargetingListRuleItemMap.ARGUMENTS,
                                RetargetingListRuleArgumentItemMap.MEMBERSHIP_LIFE_SPAN)));
    }

    @Test
    public void arrayInExternalIdField(){
        JSONObject request = new JSONObject();
        JSONObject retargetingLists = new JSONObject();
        JSONObject rules = new JSONObject();
        JSONObject arguments = new JSONObject();
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.MEMBERSHIP_LIFE_SPAN), 30);
        arguments.put(capitalize(RetargetingListRuleArgumentItemMap.EXTERNAL_ID), new Object[]{correctGoalId});
        rules.put(capitalize(RetargetingListRuleItemMap.ARGUMENTS), new Object[]{arguments});
        rules.put(capitalize(RetargetingListRuleItemMap.OPERATOR), RetargetingListRuleOperatorEnum.ANY);
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.RULES), new Object[]{rules});
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.NAME), "Name");
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.DESCRIPTION), "Description");
        retargetingLists.put(capitalize(RetargetingListUpdateItemMap.ID), id);
        request.put(capitalize(UpdateRequestMap.RETARGETING_LISTS), new Object[]{retargetingLists});
        api.userSteps.retargetingListsSteps().shouldGetJSONErrorOn(
                ServiceNames.RETARGETING_LISTS,
                LOGIN,
                Action.UPDATE,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(UpdateRequestMap.RETARGETING_LISTS,
                                RetargetingListUpdateItemMap.RULES,
                                RetargetingListRuleItemMap.ARGUMENTS,
                                RetargetingListRuleArgumentItemMap.EXTERNAL_ID)));
    }

}

