package ru.yandex.autotests.directapi.retargetinglists.update;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.*;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.UPDATE)
@Description("Проверка лимитов метода Update")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class UpdateRetargetingListsLimitTest {
    private static long CORRECT_GOAL_ID;
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING14;
    private static Long id;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        CORRECT_GOAL_ID = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        id = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(CORRECT_GOAL_ID);
    }

    @Test
    public void moreThanMaxRetargetingListsInOneRequest() {
        RetargetingListUpdateItemMap[] retargetingLists =
                new RetargetingListUpdateItemMap[AddRequestMap.MAX_AMOUNT_RETARGETING_LISTS_IN_ONE_REQUEST + 1];
        Arrays.fill(retargetingLists,
                new RetargetingListUpdateItemMap()
                        .withId(id)
                        .withRules(new RetargetingListRuleItemMap()
                                .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                        .withMembershipLifeSpan(1)
                                        .withExternalId(CORRECT_GOAL_ID))));
        api.userSteps.retargetingListsSteps().expectErrorOnUpdate(new UpdateRequestMap()
                        .withRetargetingLists(retargetingLists),
                new Api5Error(9300,
                        Api5ErrorDetailsJava.MAX_OBJECTS,
                        UpdateRequestMap.MAX_AMOUNT_OF_IDS_IN_UPDATE_REQUEST));
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }


    @Test
    public void maxRetargetingListsInOneRequest() {
        RetargetingListUpdateItemMap[] retargetingLists =
                new RetargetingListUpdateItemMap[AddRequestMap.MAX_AMOUNT_RETARGETING_LISTS_IN_ONE_REQUEST];
        Arrays.fill(retargetingLists,
                new RetargetingListUpdateItemMap()
                        .withId(id)
                        .withRules(new RetargetingListRuleItemMap()
                                .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                        .withMembershipLifeSpan(1)
                                        .withExternalId(CORRECT_GOAL_ID))));
        ExpectedResult[] results =
                new ExpectedResult[UpdateRequestMap.MAX_AMOUNT_OF_IDS_IN_UPDATE_REQUEST];
        Arrays.fill(results, ExpectedResult.errors(new Notification(9800,
                Api5ErrorDetailsJava.RETARGETING_LISTS_ID_SHOULD_BE_ONCE_IN_REQUEST,
                path(RetargetingListAddItemMap.NAME))));
        api.userSteps.retargetingListsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap()
                        .withRetargetingLists(retargetingLists),
                results
        );
    }

    @Test
    public void maxRules() {
        RetargetingListRuleItemMap[] rules =
                new RetargetingListRuleItemMap[RetargetingListAddItemMap.MAX_AMOUNT_OF_RULES];
        Arrays.fill(rules,
                new RetargetingListRuleItemMap()
                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                .withMembershipLifeSpan(1)
                                .withExternalId(CORRECT_GOAL_ID)));
        api.userSteps.retargetingListsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withRetargetingLists(
                                new RetargetingListUpdateItemMap()
                                        .withId(id)
                                        .withRules(rules)
                        ),
                ExpectedResult.success());
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void moreThanMaxRules() {
        RetargetingListRuleItemMap[] rules =
                new RetargetingListRuleItemMap[RetargetingListAddItemMap.MAX_AMOUNT_OF_RULES + 1];
        Arrays.fill(rules,
                new RetargetingListRuleItemMap()
                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                .withMembershipLifeSpan(1)
                                .withExternalId(CORRECT_GOAL_ID)));
        api.userSteps.retargetingListsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withRetargetingLists(
                                new RetargetingListUpdateItemMap()
                                        .withId(id)
                                        .withRules(rules)
                        ),
                ExpectedResult.errors(
                        new Notification(7000, Api5ErrorDetailsJava.INVALID_LIST_SIZE,
                                path(RetargetingListAddItemMap.RULES),
                                1,
                                RetargetingListAddItemMap.MAX_AMOUNT_OF_RULES)));
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

    }

    @Test
    public void maxArguments() {
        RetargetingListRuleArgumentItemMap[] arguments =
                new RetargetingListRuleArgumentItemMap[RetargetingListRuleItemMap.MAX_AMOUNT_OF_ARGUMENTS];
        Arrays.fill(arguments,
                new RetargetingListRuleArgumentItemMap()
                        .withMembershipLifeSpan(1)
                        .withExternalId(CORRECT_GOAL_ID));
        api.userSteps.retargetingListsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withRetargetingLists(
                                new RetargetingListUpdateItemMap()
                                        .withId(id)
                                        .withRules(
                                                new RetargetingListRuleItemMap()
                                                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                                        .withArgumentItems(arguments)
                                        )
                        ),
                ExpectedResult.success());
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void moreThanMaxArgument() {
        RetargetingListRuleArgumentItemMap[] arguments =
                new RetargetingListRuleArgumentItemMap[RetargetingListRuleItemMap.MAX_AMOUNT_OF_ARGUMENTS + 1];
        Arrays.fill(arguments,
                new RetargetingListRuleArgumentItemMap()
                        .withMembershipLifeSpan(1)
                        .withExternalId(CORRECT_GOAL_ID));
        api.userSteps.retargetingListsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withRetargetingLists(
                                new RetargetingListUpdateItemMap()
                                        .withId(id)
                                        .withRules(
                                                new RetargetingListRuleItemMap()
                                                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                                        .withArgumentItems(arguments)
                                        )
                        ),
                ExpectedResult.errors(
                        new Notification(7000, Api5ErrorDetailsJava.INVALID_LIST_SIZE,
                                path(RetargetingListAddItemMap.RULES, 0, RetargetingListRuleItemMap.ARGUMENTS),
                                1,
                                RetargetingListRuleItemMap.MAX_AMOUNT_OF_ARGUMENTS)));
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }
}
