package ru.yandex.autotests.directapi.retargetinglists.update;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.*;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.List;

import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.UPDATE)
@Description("Проверка работы SOAP вызова")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class UpdateRetargetingListsSoapTest {
    private static long correctGoalId;
    private static final RetargetingListRuleOperatorEnum OPERATOR_ENUM = RetargetingListRuleOperatorEnum.ANY;
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING11;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN).protocol(ProtocolType.SOAP);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private List<Long> idList;

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        correctGoalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
    }

    @Before
    public void init() {
        idList = api.userSteps.retargetingListsSteps().add(new AddRequestMap()
                .withRetargetingLists(
                        new RetargetingListAddItemMap()
                                .withRandomDescription()
                                .withRandomName()
                                .withRules(new RetargetingListRuleItemMap()
                                        .withOperator(OPERATOR_ENUM)
                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                .withRandomMembershipLifeSpan()
                                                .withExternalId(correctGoalId))))
        );
        assumeThat("добавился один объект", idList, iterableWithSize(1));
    }

    @Test
    public void testUpdateSuccess() {
        api.userSteps.retargetingListsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withRetargetingLists(
                                new RetargetingListUpdateItemMap()
                                        .withId(idList.get(0))
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(OPERATOR_ENUM)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withRandomMembershipLifeSpan()
                                                        .withExternalId(correctGoalId)))),
                ExpectedResult.success());
    }
}
