package ru.yandex.autotests.directapi.retargetinglists.update.rules;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.*;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.*;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import static org.hamcrest.Matchers.greaterThan;
import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.UPDATE)
@Description("Проверка обновления целей правил типа All")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
@RunWith(Parameterized.class)
public class UpdateRetargetingListsAllWithDiffGoalTypesTest {
    private static long goalId1;
    private static long goalId2;
    private static long segmentId;
    private static long audienceSegmentId;
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING19;
    private static List<Long> idList;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public RetargetingListRuleArgumentItemMap argumentItemMap;

    @Parameterized.Parameters(name = "{0}")
    public static Collection data() {
        prepareGoals();
        Object[][] data = new Object[][]{
                {"goal", new RetargetingListRuleArgumentItemMap()
                        .withExternalId(goalId2)
                        .withRandomMembershipLifeSpan()
                },
                {"segment", new RetargetingListRuleArgumentItemMap()
                        .withExternalId(segmentId)
                        .withRandomMembershipLifeSpan()
                },
                {"audience_segment", new RetargetingListRuleArgumentItemMap()
                        .withExternalId(audienceSegmentId)
                }
        };
        return Arrays.asList(data);
    }

    public static void prepareGoals(){
        List<Long> goalIds = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL);
        assumeThat("у клиента должно быть > 1 цели", goalIds.size(), greaterThan(1));
        goalId1 = goalIds.get(0);
        goalId2 = goalIds.get(1);
        segmentId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.SEGMENT).get(0);
        audienceSegmentId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.AUDIENCE_SEGMENT).get(0);
    }

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        idList = api.userSteps.retargetingListsSteps().add(new AddRequestMap()
                .withRetargetingLists(
                        new RetargetingListAddItemMap()
                                .withName("Name " + RandomStringUtils.randomAlphanumeric(5))
                                .withDescription("Description" + RandomStringUtils.randomAlphanumeric(5))
                                .withRules(new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.ALL)
                                        .withArgumentItems(
                                            new RetargetingListRuleArgumentItemMap()
                                                .withRandomMembershipLifeSpan()
                                                .withExternalId(goalId1)))
        ));
        assumeThat("добавился один объект", idList, iterableWithSize(1));
    }

    @Test
    public void testUpdateWithDiffGoalTypes() {
        api.userSteps.retargetingListsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withRetargetingLists(
                                new RetargetingListUpdateItemMap()
                                        .withId(idList.get(0))
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(RetargetingListRuleOperatorEnum.ALL)
                                                .withArgumentItems(argumentItemMap))),
                ExpectedResult.success());

    }
}
