package ru.yandex.autotests.directapi.retargetinglists.update.rules;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.*;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.*;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.List;

import static org.hamcrest.Matchers.greaterThan;
import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by aliho on 07.11.17.
 */

@Aqua.Test
@Features(RetargetingListsFeatures.UPDATE)
@Description("Проверки метода UPDATE условий с икомерсами целями")
@Issue("https://st.yandex-team.ru/DIRECT-72245")
public class UpdateRetargetingListsAllWithEcommerceGoalTypesTest {
    private static long goalId1;
    private static long ecommerceGoalId;
    private static final String LOGIN = Logins.LOGIN_WITH_ECOMMERCE_GOALS;
    private static List<Long> idList;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    public static RetargetingListRuleArgumentItemMap ecommerceRule;

    @BeforeClass
    public static void prepare() {
        List<Long> goalIds = api.as(Logins.SUPER_LOGIN, LOGIN).userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL);
        assumeThat("у клиента должно быть > 1 цели", goalIds.size(), greaterThan(1));
        goalId1 = goalIds.get(0);
        ecommerceGoalId = api.as(Logins.SUPER_LOGIN, LOGIN).userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.ECOMMERCE).get(0);

        ecommerceRule = new RetargetingListRuleArgumentItemMap()
                .withExternalId(ecommerceGoalId)
                .withRandomMembershipLifeSpan();

        api.as(Logins.SUPER_LOGIN, LOGIN).userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        idList = api.as(Logins.SUPER_LOGIN, LOGIN).userSteps.retargetingListsSteps().add(new AddRequestMap()
                .withRetargetingLists(
                        new RetargetingListAddItemMap()
                                .withName("Name " + RandomStringUtils.randomAlphanumeric(5))
                                .withDescription("Description" + RandomStringUtils.randomAlphanumeric(5))
                                .withRules(new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.ALL)
                                        .withArgumentItems(
                                                new RetargetingListRuleArgumentItemMap()
                                                        .withRandomMembershipLifeSpan()
                                                        .withExternalId(goalId1)))
                ));
        assumeThat("добавился один объект", idList, iterableWithSize(1));
    }

    @Test
    public void testUpdateWithEcommerceGoalType() {
        api.as(Logins.SUPER_LOGIN, LOGIN).userSteps.retargetingListsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withRetargetingLists(
                                new RetargetingListUpdateItemMap()
                                        .withId(idList.get(0))
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(RetargetingListRuleOperatorEnum.ALL)
                                                .withArgumentItems(ecommerceRule))),
                ExpectedResult.success());

    }
}
