package ru.yandex.autotests.directapi.retargetinglists.update.rules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListAddItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleArgumentItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsFeatures;
import ru.yandex.autotests.directapi.retargetinglists.RetargetingListsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 24/02/16
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(RetargetingListsFeatures.UPDATE)
@Description("Проверка диапазона значений поля MembershipLifespan")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
@RunWith(Parameterized.class)
public class UpdateRetargetingListsMembershipLifespanNegativeTest {
    private static final String LOGIN = RetargetingListsLogins.LOGIN_RETARGETING23;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long correctGoalId;

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter
    public Integer lifespan;

    @Parameterized.Parameter(1)
    public RetargetingListRuleArgumentItemMap argumentItemMap;

    @Parameterized.Parameter(2)
    public ExpectedResult result;

    @Parameterized.Parameters(name = "MembershipLifespan - {0}")
    public static Collection data() {
        prepare();
        Object[][] data = new Object[][]{
                {-1, new RetargetingListRuleArgumentItemMap()
                        .withMembershipLifeSpan(-1)
                        .withExternalId(correctGoalId), ExpectedResult.errors(
                        new Notification("en", 5005,
                                Api5ErrorDetailsJava.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                                path(RetargetingListUpdateItemMap.RULES,
                                        0,
                                        RetargetingListRuleItemMap.ARGUMENTS,
                                        0,
                                        RetargetingListRuleArgumentItemMap.MEMBERSHIP_LIFE_SPAN),
                                1,
                                540))},

                {RetargetingListRuleArgumentItemMap.MIN_MEMBERSHIP_LIFE_SPAN - 1,
                        new RetargetingListRuleArgumentItemMap()
                                .withMembershipLifeSpan(RetargetingListRuleArgumentItemMap.MIN_MEMBERSHIP_LIFE_SPAN - 1)
                                .withExternalId(correctGoalId),
                        ExpectedResult.errors(
                                new Notification("en", 5005,
                                        Api5ErrorDetailsJava.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                                        path(RetargetingListUpdateItemMap.RULES,
                                                0,
                                                RetargetingListRuleItemMap.ARGUMENTS,
                                                0,
                                                RetargetingListRuleArgumentItemMap.MEMBERSHIP_LIFE_SPAN),
                                        1,
                                        540))},

                {RetargetingListRuleArgumentItemMap.MAX_MEMBERSHIP_LIFE_SPAN_2019 + 1,
                        new RetargetingListRuleArgumentItemMap()
                                .withMembershipLifeSpan(RetargetingListRuleArgumentItemMap.MAX_MEMBERSHIP_LIFE_SPAN_2019 + 1)
                                .withExternalId(correctGoalId),
                        ExpectedResult.errors(
                                new Notification("en", 5005,
                                        Api5ErrorDetailsJava.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                                        path(RetargetingListUpdateItemMap.RULES,
                                                0,
                                                RetargetingListRuleItemMap.ARGUMENTS,
                                                0,
                                                RetargetingListRuleArgumentItemMap.MEMBERSHIP_LIFE_SPAN),
                                        1,
                                        540))},
        };
        return Arrays.asList(data);
    }

    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        correctGoalId =
                api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
    }

    @Test
    public void testLifespanValidation() {
        List<Long> idList = api.userSteps.retargetingListsSteps().add(new AddRequestMap()
                .withRetargetingLists(
                        new RetargetingListAddItemMap()
                                .withRandomName()
                                .withRandomDescription()
                                .withRules(new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.ALL)
                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                .withRandomMembershipLifeSpan()
                                                .withExternalId(correctGoalId))))
        );
        assumeThat("добавился один объект", idList, iterableWithSize(1));

        api.userSteps.retargetingListsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                .withRetargetingLists(
                        new RetargetingListUpdateItemMap()
                                .withId(idList.get(0))
                                .withRules(new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.ALL)
                                        .withArgumentItems(argumentItemMap))), result);
    }
}

