package ru.yandex.autotests.directapi.sitelinks;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.sitelinks.SitelinksSetFieldEnum;
import org.json.simple.JSONObject;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.sitelinks.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 2/9/15.
 * https://st.yandex-team.ru/TESTIRT-2819
 */
@Aqua.Test
@Features(SitelinksFeatures.GENERAL)
@Stories(ApiStories.JSON5)
@Description("Неверный Action в сервисе сайтлинков")
@RunWith(Parameterized.class)
public class JsonWrongActionTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().protocol(ProtocolType.JSON).as(SitelinksLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToUser() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SitelinksLogins.CLIENT);
    }

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public Action action;

    @Parameterized.Parameter(2)
    public Api5Error expectedError;

    @Parameterized.Parameters(name = "{0} - {1}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Пустая строка в поле Action", Action.ACTION_EMPTY,
                        new Api5Error(55, Api5ErrorDetailsJava.OPERATION_IS_NOT_SET)},
                {"Неверное значение в поле Action", Action.ACTION_INVALID,
                        new Api5Error(55, Api5ErrorDetailsJava.OPERATION_IS_NOT_SET)},
                {"Существующий, но не входящий в сервис Action", Action.UPDATE,
                        new Api5Error(55, Api5ErrorDetailsJava.OPERATION_IS_NOT_SET)}
        });
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3785")
    public void wrongValueInActionField() {
        JSONObject request = new JSONObject();
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new String[]{SitelinksSetFieldEnum.ID.value()});
        api.userSteps
                .shouldGetJSONErrorOn(ServiceNames.SITELINKS, SitelinksLogins.CLIENT, action, request, expectedError);
    }
}
