package ru.yandex.autotests.directapi.sitelinks.add;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.sitelinks.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinkMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinksSetAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import java.util.Arrays;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphabetic;
import static ru.yandex.autotests.directapi.model.api5.general.ExpectedResult.errors;
import static ru.yandex.autotests.directapi.model.api5.general.ExpectedResult.success;

/**
 * Created by semkagtn on 12.10.15.
 * https://st.yandex-team.ru/TESTIRT-7422
 */
@Aqua.Test
@Features(SitelinksFeatures.ADD)
@Description("Проверка валидации поля Description")
@Issue("https://st.yandex-team.ru/DIRECT-47003")
@RunWith(Parameterized.class)
public class AddDescriptionValidationTest {

    private static final String LOGIN = SitelinksLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String caseDescription;

    @Parameterized.Parameter(1)
    public String description;

    @Parameterized.Parameter(2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}: title = {1}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"описание на английском", "hello world", success()},
                {"описание на турецком", "şakak", success()},
                {"описание на русском", "рашен лэнгуич", success()},
                {"описание на украинском", "щось не працює", success()},
                {"описание на казахском", "Сәлеметсіз бе", success()},
                {"заголовок на белорусском", "аплата наяўнымі", success()},
                {"описание на японсокм (недопустимые символы)", "挨拶",
                        errors(new Notification(5002, Api5ErrorDetails.WRONG_SYMBOLS_IN_SITELINK_DESCRIPTION))},
                {"описание с точкой", "Привет мир.", success()},
                {"описание с восклицательным знаком", "Привет мир!",
                        errors(new Notification(5002, Api5ErrorDetails.WRONG_SYMBOLS_IN_SITELINK_DESCRIPTION))},
                {"описание с вопросительным знаком", "Привет мир?",
                        errors(new Notification(5002, Api5ErrorDetails.WRONG_SYMBOLS_IN_SITELINK_DESCRIPTION))},
                {"описание с запятой", "Привет, мир", success()},
                {"отсутствие описания", null, success()},
                {"пустое описание", "",
                        errors(new Notification(5003, Api5ErrorDetails.SITELINKS_DESCRIPTION_NOT_ENTERED))},
                {"описание максимальной длины", randomAlphabetic(SitelinkMap.MAX_DESCRIPTION_LENGTH), success()},
                {"описание максимальной длины, плюс пробелы в начале и в конце",
                        "  " + randomAlphabetic(SitelinkMap.MAX_DESCRIPTION_LENGTH) + "  ", success()},
                {"описание, длина которого превышает максимальную",
                        randomAlphabetic(SitelinkMap.MAX_DESCRIPTION_LENGTH + 1),
                        errors(new Notification(5001, Api5ErrorDetails.LENGTH_OF_SITELINK_DESCRIPTION_EXCEEDED,
                                SitelinkMap.MAX_DESCRIPTION_LENGTH))},
                {"описание, содержащее цифры", "Привет мир 1", success()}
        });
    }

    @Before
    public void addUnitsToUser() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3790")
    public void createSitelinksSetWithDescription() {
        api.userSteps.sitelinksSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withSitelinksSets(new SitelinksSetAddItemMap()
                                .withSitelinks(new SitelinkMap()
                                        .randomSitelinkWithDescription()
                                        .withDescription(description))),
                expectedResult);
    }
}
