package ru.yandex.autotests.directapi.sitelinks.add;

import org.apache.commons.lang3.RandomStringUtils;
import org.json.simple.JSONObject;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.sitelinks.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinkMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinksSetAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by semkagtn on 2/9/15.
 * https://st.yandex-team.ru/TESTIRT-4100
 */
@Aqua.Test
@Features(SitelinksFeatures.ADD)
@Stories(ApiStories.JSON5)
@Description("Валидация JSON-запроса при добавлении сайтлинков")
public class AddJsonValidationTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().protocol(ProtocolType.JSON).as(SitelinksLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToUser() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SitelinksLogins.CLIENT);
    }

    @Test
    @Description("Не массив в поле SitelinksSets")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3795")
    public void notAnArrayInSitelinksSetsField() {
        JSONObject request = new JSONObject();
        Object sitelinksSet = new SitelinksSetAddItemMap()
                .defaultSitelinksSet(1).getBean();
        request.put(path(AddRequestMap.SITELINKS_SETS), sitelinksSet);
        api.userSteps.sitelinksSteps().expectErrorOnAdd(request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                        path(AddRequestMap.SITELINKS_SETS)));
    }

    @Test
    @Description("Не массив в поле SitelinksSets.Sitelinks")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3796")
    public void notAnArrayInSitelinksField() {
        JSONObject request = new JSONObject();
        JSONObject sitelinksSet = new JSONObject();
        Object sitelink = new SitelinkMap()
                .randomSitelinkWithDescription().getBean();
        sitelinksSet.put(path(SitelinksSetAddItemMap.SITELINKS), sitelink);
        request.put(path(AddRequestMap.SITELINKS_SETS), new Object[]{sitelinksSet});
        api.userSteps.sitelinksSteps().expectErrorOnAdd(request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                        path(AddRequestMap.SITELINKS_SETS, SitelinksSetAddItemMap.SITELINKS)));
    }

    @Test
    @Description("Массив в поле SitelinksSets.Sitelinks.Title")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3794")
    public void arrayInTitleField() {
        JSONObject request = new JSONObject();
        JSONObject sitelinksSet = new JSONObject();
        JSONObject sitelink = new JSONObject();
        sitelink.put(path(SitelinkMap.TITLE),
                new String[]{RandomStringUtils.randomAlphabetic(SitelinkMap.MAX_TITLE_LENGTH / 2)});
        sitelink.put(path(SitelinkMap.HREF),
                "http://" + RandomStringUtils.randomAlphabetic(SitelinkMap.MAX_DOMAIN_LENGTH / 2) + ".ru");
        sitelinksSet.put(path(SitelinksSetAddItemMap.SITELINKS), new Object[]{sitelink});
        request.put(path(AddRequestMap.SITELINKS_SETS), new Object[]{sitelinksSet});
        api.userSteps.sitelinksSteps().expectErrorOnAdd(request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(AddRequestMap.SITELINKS_SETS, SitelinksSetAddItemMap.SITELINKS, SitelinkMap.TITLE)));
    }

    @Test
    @Description("Массив в поле SitelinksSets.Sitelinks.Href")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3797")
    public void arrayInHrefField() {
        JSONObject request = new JSONObject();
        JSONObject sitelinksSet = new JSONObject();
        JSONObject sitelink = new JSONObject();
        sitelink.put(path(SitelinkMap.TITLE),
                RandomStringUtils.randomAlphabetic(SitelinkMap.MAX_TITLE_LENGTH / 2));
        sitelink.put(path(SitelinkMap.HREF),
                new String[]{
                        "http://" + RandomStringUtils.randomAlphabetic(SitelinkMap.MAX_DOMAIN_LENGTH / 2) + ".ru"});
        sitelinksSet.put(path(SitelinksSetAddItemMap.SITELINKS), new Object[]{sitelink});
        request.put(path(AddRequestMap.SITELINKS_SETS), new Object[]{sitelinksSet});
        api.userSteps.sitelinksSteps().expectErrorOnAdd(request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(AddRequestMap.SITELINKS_SETS, SitelinksSetAddItemMap.SITELINKS, SitelinkMap.HREF)));
    }

    @Test
    @Description("Число сайтлинков в массиве SitelinksSets.Sitelinks меньше минимального")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3798")
    public void emptyArrayInSitelinksField() {
        api.userSteps.sitelinksSteps().expectErrorOnAdd(new AddRequestMap()
                        .withSitelinksSets(
                                new SitelinksSetAddItemMap()
                                        .defaultSitelinksSet(SitelinksSetAddItemMap.MIN_SITELINKS_AMOUNT - 1)),
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                        path(AddRequestMap.SITELINKS_SETS, SitelinksSetAddItemMap.SITELINKS), 1));
    }
}
