package ru.yandex.autotests.directapi.sitelinks.add;

import com.yandex.direct.api.v5.sitelinks.SitelinksSetGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.sitelinks.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinkMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinksSetAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.List;

import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 2/2/15.
 * https://st.yandex-team.ru/TESTIRT-4100
 */
@Aqua.Test
@Features(SitelinksFeatures.ADD)
@Description("Проверка добавления сайтлинков, когда в запросе присутствуют валидные и невалидные объекты")
@Tag(TagDictionary.TRUNK)
public class AddMultipleErrorTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SitelinksLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private AddRequestMap addRequestMap;

    @Before
    public void initADdRequestMap() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SitelinksLogins.CLIENT);
        addRequestMap = new AddRequestMap().withSitelinksSets(
                new SitelinksSetAddItemMap()
                        .defaultSitelinksSet(1),
                new SitelinksSetAddItemMap()
                        .withSitelinks(new SitelinkMap()
                                .withRandomTitle(SitelinkMap.MAX_TITLE_LENGTH * 2)
                                .withRandomHref()));
    }

    @Test
    @Description("Создать валидный и не валидный наборы сайтлинков в одном запросе и проверить ответ")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3803")
    public void addValidAndInvalidSitelinksSetsResponse() {
        api.userSteps.sitelinksSteps().shouldGetResultOnAdd(addRequestMap,
                ExpectedResult.success(),
                ExpectedResult.errors(new Notification(5001,
                        Api5ErrorDetails.MAXIMUM_TEXT_LENGTH_OF_ONE_QUICK_LINK_HAS_BEEN_EXCEEDED,
                        SitelinkMap.MAX_TITLE_LENGTH)));
    }

    @Test
    @Description("Создать валидные и невалидный наборы сайтлинков в одном запросе и проверить," +
            " что валидный объект создался")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3804")
    public void addValidAndInvalidSitelinksSets() {
        List<Long> ids = api.userSteps.sitelinksSteps().add(addRequestMap);
        assumeThat("создался один набор сайтлинков", ids, hasSize(1));

        List<SitelinksSetGetItem> result = api.userSteps.sitelinksSteps().get(ids);
        assertThat("создался один сайтлинк", result, hasSize(1));
    }
}
