package ru.yandex.autotests.directapi.sitelinks.add;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.sitelinks.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinksSetAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.List;

import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 2/3/15.
 * https://st.yandex-team.ru/TESTIRT-4100
 */
@Aqua.Test
@Features(SitelinksFeatures.ADD)
@Description("Добавление одинаковых наборов сайтлинков")
@Tag(TagDictionary.TRUNK)
public class AddSameSitelinksSetsTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SitelinksLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private SitelinksSetAddItemMap addItemMap;

    @Before
    public void initAddItemMap() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SitelinksLogins.CLIENT);
        addItemMap = new SitelinksSetAddItemMap()
                .defaultSitelinksSet(1);
    }

    @Test
    @Description("Добавить два одинаковых набора сайтлинков за один запрос")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3806")
    public void addSameSitelinksSetsWithOneRequest() {
        api.userSteps.sitelinksSteps().shouldGetResultOnAdd(new AddRequestMap()
                .withSitelinksSets(addItemMap, addItemMap),
                ExpectedResult.success(), ExpectedResult.success());
    }

    @Test
    @Description("Добавить два одинаковых набора сайтлинков за два запроса")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3807")
    public void addSameSitelinksSetsWithTwoRequests() {
        List<Long> ids = api.userSteps.sitelinksSteps().add(new AddRequestMap()
                .withSitelinksSets(addItemMap));
        assumeThat("создался один набор сайтлинков", ids, hasSize(1));
        long id = ids.get(0);

        api.userSteps.sitelinksSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withSitelinksSets(addItemMap),
                ExpectedResult.warnings(id, new Notification(10120)));
    }
}
