package ru.yandex.autotests.directapi.sitelinks.add;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.sitelinks.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinksSetAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by semkagtn on 1/29/15.
 * https://st.yandex-team.ru/TESTIRT-4100
 */
@Aqua.Test
@Features(SitelinksFeatures.ADD)
@Description("Создать набор сайтлинков с числом сайтлинков больше или меньше максимального")
@Tag(TagDictionary.TRUNK)
public class AddSitelinkSetOfVariousSitelinksAmountNegativeTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SitelinksLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToUser() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SitelinksLogins.CLIENT);
    }

    @Test
    @Description("Создать набор сайтлинков с сайтлинками, число которых больше максимального")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3808")
    public void addSitelinksSetOfGreaterThanMaxSitelinksAmount() {
        api.userSteps.sitelinksSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withSitelinksSets(
                                new SitelinksSetAddItemMap()
                                        .defaultSitelinksSet(SitelinksSetAddItemMap.MAX_SITELINKS_AMOUNT + 1)),
                ExpectedResult.errors(
                        new Notification(7000, Api5ErrorDetails.NUMBER_OF_QUICK_LINKS_SHOULD_BE_FROM_TO,
                                SitelinksSetAddItemMap.MIN_SITELINKS_AMOUNT,
                                SitelinksSetAddItemMap.MAX_SITELINKS_AMOUNT)));
    }

    @Test
    @Description("Создать набор сайтлинков с сайтлинками, число которых меньше минимального")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3809")
    public void addSitelinksSetOfLessThanMinSitelinksAmount() {
        api.userSteps.sitelinksSteps().expectErrorOnAdd(new AddRequestMap()
                        .withSitelinksSets(
                                new SitelinksSetAddItemMap()
                                        .defaultSitelinksSet(SitelinksSetAddItemMap.MIN_SITELINKS_AMOUNT - 1)),
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                        path(AddRequestMap.SITELINKS_SETS, SitelinksSetAddItemMap.SITELINKS), 1));
    }
}
