package ru.yandex.autotests.directapi.sitelinks.add;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.sitelinks.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinkMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinksSetAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

/**
 * Created by semkagtn on 2/5/15.
 * https://st.yandex-team.ru/TESTIRT-4100
 */
@Aqua.Test
@Features(SitelinksFeatures.ADD)
@Description("Добавление сайтлинков с недопустимым заголовком")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AddSitelinkWithVariousTitleNegativeTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SitelinksLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String title;

    @Parameterized.Parameter(2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Добавить сайтлинк с заголовком, который состоит из нескольких пробелов", "   ",
                        ExpectedResult.errors(new Notification(5003, Api5ErrorDetails.QUICK_LINK_TEXT_NOT_ENTERED))},

                {"Добавить сайтлинк с заголовком, который содержит знак \"!\"", "Привет мир!",
                        ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.SITELINKS_WRONG_TITLE))},

                {"Добавить сайтлинк с заголовком, который содержит знак \"?\"", "Привет мир?",
                        ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.SITELINKS_WRONG_TITLE))},

                {"Добавить сайтлинк, который содержит запрещённые символы", "サムライ",
                        ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.SITELINKS_WRONG_TITLE))}
        });
    }

    @Before
    public void addUnitsToUser() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SitelinksLogins.CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3810")
    public void addSitelinkWithTitle() {
        api.userSteps.sitelinksSteps().shouldGetResultOnAdd(new AddRequestMap()
                .withSitelinksSets(new SitelinksSetAddItemMap()
                        .withSitelinks(new SitelinkMap()
                                .withTitle(title)
                                .withRandomHref())),
                expectedResult);
    }
}
