package ru.yandex.autotests.directapi.sitelinks.add;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.sitelinks.SitelinksSetGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.sitelinks.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinkGetMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinkMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinksSetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinksSetGetItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by semkagtn on 2/3/15.
 * https://st.yandex-team.ru/TESTIRT-4100
 */
@Aqua.Test
@Features(SitelinksFeatures.ADD)
@Description("Добавление сайтлинков с различными заголовками")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AddSitelinkWithVariousTitlesTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SitelinksLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String title;

    @Parameterized.Parameters(name = "{0}: {1}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Добавить сайтлинк с русским заголовком", "Сайтлинк"},
                {"Добавить сайтлинк с украинским заголовком", "Горілка"},
                {"Добавить сайтлинк с латинским заголовком", "English sitelink"},
                {"Добавить сайтлинк с турецким заголовком", "türkiye"},
                {"Добавить сайтлинк с казахским заголовком", "арақ"},
                {"Добавить сайтлинк со знаками препинания", "Привет, мир."},
        });
    }

    @Before
    public void addUnitsToUser() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SitelinksLogins.CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3811")
    public void addSitelinkWithTitleResponse() {
        api.userSteps.sitelinksSteps().shouldGetResultOnAdd(new AddRequestMap()
                .withSitelinksSets(new SitelinksSetAddItemMap()
                        .withSitelinks(new SitelinkMap()
                                .withTitle(title)
                                .withRandomHref())),
                ExpectedResult.success());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3812")
    public void addSitelinkWithTitleSave() {
        List<Long> ids = api.userSteps.sitelinksSteps().add(new AddRequestMap()
                .withSitelinksSets(new SitelinksSetAddItemMap()
                        .withSitelinks(new SitelinkMap()
                                .withTitle(title)
                                .withRandomHref())));
        assumeThat("добавился один набор сайтлинков", ids, hasSize(1));

        List<SitelinksSetGetItem> result = api.userSteps.sitelinksSteps().get(ids);
        assertThat("заголовок сайтлинка сохранился верно", result, beanEquivalent(Arrays.asList(
                (SitelinksSetGetItem) new SitelinksSetGetItemMap()
                        .withSitelinks(new SitelinkGetMap()
                                .withTitle(title)).getBean())));
    }
}
