package ru.yandex.autotests.directapi.sitelinks.add;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.sitelinks.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinksSetAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

/**
 * Created by pavryabov on 21.04.16.
 * https://st.yandex-team.ru/TESTIRT-9088
 */
@Aqua.Test
@Features(SitelinksFeatures.ADD)
@Description("Проверка агентств и субклиентов. Позитивные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-50734")
@RunWith(Parameterized.class)
public class AddSitelinksAgenciesAndSubclientsTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String operator;

    @Parameterized.Parameter(2)
    public String client;

    @Parameterized.Parameter(3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {"агентство - субклиент с правами редактирования",
                        SitelinksLogins.AGENCY_CAMPAIGNS, SitelinksLogins.SUB_CLIENT_WITH_EDIT_RIGHTS, ExpectedResult.success()},
                {"агентство - субклиент без прав редактирования",
                        SitelinksLogins.AGENCY_CAMPAIGNS, SitelinksLogins.SUB_CLIENT_WITHOUT_EDIT_RIGHTS, ExpectedResult.success()},
                {"представитель агентства - субклиент",
                        SitelinksLogins.AGENCY_REP_CAMPAIGNS, SitelinksLogins.SUBCLIENT_CAMPAIGNS, ExpectedResult.success()},
                {"сервисируемый клиент",
                        SitelinksLogins.SERV_CLIENT, null, ExpectedResult.success()},
                {"субклиент с правами редактирования",
                        Logins.SUB_CLIENT_WITH_EDIT_RIGHTS, null, ExpectedResult.success()},

        };
        return Arrays.asList(data);
    }

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(operator);
    }

    @Test
    public void checkRightsToAddSitelinks() {
        api.as(Logins.SUPER_LOGIN, operator).userSteps.sitelinksSteps()
                .shouldGetResultOnAdd(client, new AddRequestMap()
                                .withSitelinksSets(new SitelinksSetAddItemMap()
                                        .defaultSitelinksSet(1)),
                        expectedResult
                );
    }
}
