package ru.yandex.autotests.directapi.sitelinks.add;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.sitelinks.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinksSetAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.ArrayList;
import java.util.Collection;

/**
 * Created by semkagtn on 10/7/14.
 * https://st.yandex-team.ru/TESTIRT-4100
 */
@Aqua.Test
@Features(SitelinksFeatures.ADD)
@Description("Создать набор сайтлинков с разным числом сайтлинков в нём")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AddSitelinksSetOfVariousSitelinksAmountTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SitelinksLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public int sitelinksAmount;

    @Parameterized.Parameters(name = "Создать набор сайтлинков с числом сайтлинков равным {0}")
    public static Collection<Object[]> data() {
        Collection<Object[]> parameters = new ArrayList<>();
        for (int i = SitelinksSetAddItemMap.MIN_SITELINKS_AMOUNT; i <= SitelinksSetAddItemMap.MAX_SITELINKS_AMOUNT; i++) {
            parameters.add(new Object[]{i});
        }
        return parameters;
    }

    @Before
    public void addUnitsToUser() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SitelinksLogins.CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3813")
    public void addOneSitelinksSetWithSitelinks() {
        api.userSteps.sitelinksSteps().shouldGetResultOnAdd(SitelinksLogins.CLIENT,
                new AddRequestMap()
                .withSitelinksSets(new SitelinksSetAddItemMap()
                        .defaultSitelinksSet(sitelinksAmount)),
                ExpectedResult.success());
    }
}
