package ru.yandex.autotests.directapi.sitelinks.add;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.sitelinks.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinksSetAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by semkagtn on 1/29/15.
 * https://st.yandex-team.ru/TESTIRT-4100
 */
@Aqua.Test
@Features(SitelinksFeatures.ADD)
@Description("Проверка ограничения на число создаваемых наборов сайтлинков за один запрос")
@Tag(TagDictionary.TRUNK)
public class AddSitelinksSetsAmountRestrictionTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SitelinksLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToUser() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SitelinksLogins.CLIENT);
    }

    @Test
    @Description("Создать " + AddRequestMap.MAX_SITELINKS_SETS_AMOUNT + " наборов сайтлинков за один запрос")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3814")
    public void addSitelinksSetsMaxAmount() {
        SitelinksSetAddItemMap[] sitelinksSets = generateSitelinksItemMaps(AddRequestMap.MAX_SITELINKS_SETS_AMOUNT);

        ExpectedResult[] expectedResults = new ExpectedResult[AddRequestMap.MAX_SITELINKS_SETS_AMOUNT];
        Arrays.fill(expectedResults, ExpectedResult.success());

        api.userSteps.sitelinksSteps().shouldGetResultOnAdd(new AddRequestMap()
                .withSitelinksSets(sitelinksSets),
                expectedResults);
    }

    @Test
    @Description("Создать наборы сайтлинков, число которых на единицу больше, чем " +
            AddRequestMap.MAX_SITELINKS_SETS_AMOUNT)
    @ru.yandex.qatools.allure.annotations.TestCaseId("3815")
    public void addSitelinksSetsOfGreaterThanMaxAmount() {
        SitelinksSetAddItemMap[] sitelinksSets = generateSitelinksItemMaps(AddRequestMap.MAX_SITELINKS_SETS_AMOUNT + 1);

        api.userSteps.sitelinksSteps().expectErrorOnAdd(new AddRequestMap()
                .withSitelinksSets(sitelinksSets),
                new Api5Error(9300, Api5ErrorDetailsJava.MAX_OBJECTS, AddRequestMap.MAX_SITELINKS_SETS_AMOUNT));
    }

    @Test
    @Description("Создать ноль наборов сайтлинков за один запрос")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3816")
    public void addZeroSitelinksSets() {
        api.userSteps.sitelinksSteps().expectErrorOnAdd(new AddRequestMap()
                .withSitelinksSets(),
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                        path(AddRequestMap.SITELINKS_SETS), 1));
    }

    private SitelinksSetAddItemMap[] generateSitelinksItemMaps(int amount) {
        SitelinksSetAddItemMap[] sitelinksSets = new SitelinksSetAddItemMap[amount];
        for (int i = 0; i < sitelinksSets.length; i++) {
            sitelinksSets[i] = new SitelinksSetAddItemMap().defaultSitelinksSet(1);
        }
        return sitelinksSets;
    }
}
