package ru.yandex.autotests.directapi.sitelinks.add;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.sitelinks.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinkMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinksSetAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by lightelfik on 11/3/16.
 * https://st.yandex-team.ru/TESTIRT-8523
 */
@Aqua.Test
@Features(SitelinksFeatures.ADD)
@Description("Добавление наборов сайтлинков с одинаковыми последними сайтлинками")
public class AddSitelinksSetsWithSameLastSitelinkTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SitelinksLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void initAddItemMap() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SitelinksLogins.CLIENT);
    }

    @Test
    @Description("Добавить два набора сайтлинков с одинаковыми последними сайтлинками")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3807")
    public void addSitelinksSetsWithSameLastSitelink() {
        SitelinkMap sitelinkMap = new SitelinkMap()
                .withHref("http://qwe.ru").withTitle("Последний сайтлинк в наборе");

        SitelinksSetAddItemMap firstSitelinksSet = new SitelinksSetAddItemMap()
                .withSitelinks(
                        new SitelinkMap().randomSitelink(),
                        new SitelinkMap().randomSitelink(),
                        new SitelinkMap().randomSitelink(),
                        sitelinkMap
                );

        SitelinksSetAddItemMap secondSitelinksSet = new SitelinksSetAddItemMap()
                .withSitelinks(
                        new SitelinkMap().randomSitelink(),
                        new SitelinkMap().randomSitelink(),
                        new SitelinkMap().randomSitelink(),
                        sitelinkMap
                );

        api.userSteps.sitelinksSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withSitelinksSets(firstSitelinksSet, secondSitelinksSet),
                ExpectedResult.success(), ExpectedResult.success());
    }
}
