package ru.yandex.autotests.directapi.sitelinks.add;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.sitelinks.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinkMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinksSetAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 2/2/15.
 * https://st.yandex-team.ru/TESTIRT-4100
 */
@Aqua.Test
@Features(SitelinksFeatures.ADD)
@Description("Добавление сайтлинков с одинаковыми заголовками")
@Tag(TagDictionary.TRUNK)
public class AddSitelinksWithSameTitleTest {

    private static final String TITLE = RandomStringUtils.randomAlphabetic(SitelinkMap.MAX_TITLE_LENGTH / 2);

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SitelinksLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToUser() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SitelinksLogins.CLIENT);
    }

    @Test
    @Description("Создать два сайтлинка с одинаковым заголовком в одном наборе")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3819")
    public void addTwoSitelinksWithSameTitleInSameSitelinksSet() {
        api.userSteps.sitelinksSteps().shouldGetResultOnAdd(new AddRequestMap()
                .withSitelinksSets(new SitelinksSetAddItemMap()
                        .withSitelinks(
                                new SitelinkMap()
                                        .withTitle(TITLE)
                                        .withRandomHref(),
                                new SitelinkMap()
                                        .withTitle(TITLE)
                                        .withRandomHref())),
                ExpectedResult.errors(
                        new Notification(5007, Api5ErrorDetails.QUICK_LINKS_TEXTS_SHOULD_NOT_BE_IDENTICAL),
                        new Notification(5007, Api5ErrorDetails.QUICK_LINKS_TEXTS_SHOULD_NOT_BE_IDENTICAL)));
    }

    @Test
    @Description("Создать два сайтлинка с одинаковым заголовком в разных наборах")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3820")
    public void addTwoSitelinksWithSameTitleInVariouslinksSet() {
        api.userSteps.sitelinksSteps().shouldGetResultOnAdd(new AddRequestMap()
                .withSitelinksSets(
                        new SitelinksSetAddItemMap()
                                .withSitelinks(new SitelinkMap()
                                        .withTitle(TITLE)
                                        .withRandomHref()),
                        new SitelinksSetAddItemMap()
                                .withSitelinks(new SitelinkMap()
                                        .withTitle(TITLE)
                                        .withRandomHref())),
                ExpectedResult.success(), ExpectedResult.success());
    }
}
