package ru.yandex.autotests.directapi.sitelinks.add;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.sitelinks.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinkMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinksSetAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by semkagtn on 12.05.15.
 * https://st.yandex-team.ru/TESTIRT-4100
 */
@Aqua.Test
@Features(SitelinksFeatures.ADD)
@Description("Запросы на добавление наборов сайтлинков по протоколу SOAP")
public class AddSoapTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SitelinksLogins.CLIENT).protocol(ProtocolType.SOAP);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToUser() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SitelinksLogins.CLIENT);
    }

    @Test
    @Description("Запрос на добавление набора сайтлинков без поля SitelinksSets")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3822")
    public void requestWithoutSitelinksSetsField() {
        api.userSteps.sitelinksSteps().expectErrorOnAdd(new AddRequestMap()
                        .withSitelinksSets(null),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(AddRequestMap.SITELINKS_SETS)));
    }

    @Test
    @Description("Запрос на добавление набора сайтлинков без поля SitelinksSets.Sitelinks")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3823")
    public void requestWithoutSitelinksField() {
        api.userSteps.sitelinksSteps().expectErrorOnAdd(new AddRequestMap()
                        .withSitelinksSets(new SitelinksSetAddItemMap()
                                .withSitelinks(null)),
                new Api5Error(8000, Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        path(AddRequestMap.SITELINKS_SETS), path(SitelinksSetAddItemMap.SITELINKS)));
    }

    @Test
    @Description("Запрос на добаление набора сайтлинков без поля SitelinksSets.Sitelinks.Title")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3824")
    public void requestWithoutTitleField() {
        api.userSteps.sitelinksSteps().expectErrorOnAdd(new AddRequestMap()
                        .withSitelinksSets(new SitelinksSetAddItemMap()
                                .withSitelinks(new SitelinkMap()
                                        .withTitle(null)
                                        .withRandomHref())),
                new Api5Error(8000, Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        path(AddRequestMap.SITELINKS_SETS, SitelinksSetAddItemMap.SITELINKS), path(SitelinkMap.TITLE)));
    }

    @Test
    @Description("Запрос на добавление набора сайтлинков без поля SitelinksSets.Sitelinks.Href")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3825")
    public void requestWithoutHrefField() {
        api.userSteps.sitelinksSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withSitelinksSets(new SitelinksSetAddItemMap()
                                .withSitelinks(new SitelinkMap()
                                        .withRandomTitle()
                                        .withHref(null))),
                ExpectedResult.errors(new Notification(6000,
                        Api5ErrorDetailsJava.ONE_OF_HREF_OR_TURBOLANDING_ID_MUST_BE_NOT_NULL)));
    }

    @Test
    @Description("Валидный запрос на добавление наборов сайтлинков")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3821")
    public void correctRequest() {
        api.userSteps.sitelinksSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withSitelinksSets(new SitelinksSetAddItemMap()
                                .defaultSitelinksSet(1)),
                ExpectedResult.success());
    }
}
