package ru.yandex.autotests.directapi.sitelinks.add;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.sitelinks.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinkMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinksSetAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 2/2/15.
 * https://st.yandex-team.ru/TESTIRT-4100
 */
@Aqua.Test
@Features(SitelinksFeatures.ADD)
@Description("Проверка ограничений на длину заголовка сайтлинков")
@Tag(TagDictionary.TRUNK)
public class AddTitleLengthRestrictionTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SitelinksLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToUser() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SitelinksLogins.CLIENT);
    }

    @Test
    @Description("Добавить сайтлинк, длина заголовка которого равна " + SitelinkMap.MAX_TITLE_LENGTH)
    @ru.yandex.qatools.allure.annotations.TestCaseId("3828")
    public void addSitelinkWithMaxTitleLength() {
        api.userSteps.sitelinksSteps().shouldGetResultOnAdd(new AddRequestMap()
                .withSitelinksSets(new SitelinksSetAddItemMap()
                        .withSitelinks(new SitelinkMap()
                                .withRandomTitle(SitelinkMap.MAX_TITLE_LENGTH)
                                .withRandomHref())),
                ExpectedResult.success());
    }

    @Test
    @Description("Добавить сайтлинк длина заголовка которого на единицу больше " + SitelinkMap.MAX_TITLE_LENGTH)
    @ru.yandex.qatools.allure.annotations.TestCaseId("3829")
    public void addSitelinkWithGreaterThanMaxTitleLength() {
        api.userSteps.sitelinksSteps().shouldGetResultOnAdd(new AddRequestMap()
                .withSitelinksSets(new SitelinksSetAddItemMap()
                        .withSitelinks(new SitelinkMap()
                                .withRandomTitle(SitelinkMap.MAX_TITLE_LENGTH + 1)
                                .withRandomHref())),
                ExpectedResult.errors(new Notification(5001,
                        Api5ErrorDetails.MAXIMUM_TEXT_LENGTH_OF_ONE_QUICK_LINK_HAS_BEEN_EXCEEDED,
                        SitelinkMap.MAX_TITLE_LENGTH)));
    }
}
