package ru.yandex.autotests.directapi.sitelinks.add;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

import com.yandex.direct.api.v5.sitelinks.SitelinksSetGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.sitelinks.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinkMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinksSetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinksSetGetItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by semkagtn on 12.10.15.
 * https://st.yandex-team.ru/TESTIRT-7422
 */
@Aqua.Test
@Features(SitelinksFeatures.ADD)
@Description("Проверка корректности сохранения полей сайтлинков с описанием после их добавления")
@Issue("https://st.yandex-team.ru/DIRECT-46995")
public class AddWithDescriptionAndCheckFieldsTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SitelinksLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToUser() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SitelinksLogins.CLIENT);
    }

    @Test
    @Description("Добавить один набор сайтлинков с одним сайтлинком и проверить записанные поля в результате")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3841")
    public void addSitelinksSetWithOneSitelink() {
        SitelinkMap sitelinkMap = new SitelinkMap()
                .randomSitelinkWithDescription();

        List<Long> ids = api.userSteps.sitelinksSteps().add(new AddRequestMap()
                .withSitelinksSets(new SitelinksSetAddItemMap()
                        .withSitelinks(sitelinkMap)));
        assumeThat("добавился один набор сайтлинков", ids, hasSize(1));
        long id = ids.get(0);

        List<SitelinksSetGetItem> actualResult = api.userSteps.sitelinksSteps().get(id);
        assertThat("набор сайтлинков сохранился верно", actualResult, beanEquivalent(Arrays.asList(
                (SitelinksSetGetItem) new SitelinksSetGetItemMap()
                        .withSitelinks(sitelinkMap.asSitelinkGetMap())
                        .withId(id).getBean())));
    }

    @Test
    @Description("Добавить один набор сайтлинков с двумя сайтлинками и проверить записанные поля в результате")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3842")
    public void addSitelinksSetWithTwoSitelinks() {
        SitelinkMap firstSitelinkMap = new SitelinkMap()
                .randomSitelinkWithDescription();
        SitelinkMap secondSitelinkMap = new SitelinkMap()
                .randomSitelinkWithDescription();

        List<Long> ids = api.userSteps.sitelinksSteps().add(new AddRequestMap()
                .withSitelinksSets(new SitelinksSetAddItemMap()
                        .withSitelinks(firstSitelinkMap, secondSitelinkMap)));
        assumeThat("добавился один набор сайтлинков", ids, hasSize(1));
        long id = ids.get(0);

        List<SitelinksSetGetItem> actualResult = api.userSteps.sitelinksSteps().get(id);
        assertThat("набор сайтлинков сохранился верно", actualResult, beanEquivalent(Arrays.asList(
                (SitelinksSetGetItem) new SitelinksSetGetItemMap()
                        .withSitelinks(firstSitelinkMap.asSitelinkGetMap(), secondSitelinkMap.asSitelinkGetMap())
                        .withId(id).getBean())));
    }

    @Test
    @Description("Добавить два набора сайтлинков и проверить записанные поля в результате")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3843")
    public void addTwoSitelinksSets() {
        SitelinkMap firstSitelinkMap = new SitelinkMap()
                .randomSitelinkWithDescription();
        SitelinkMap secondSitelinkMap = new SitelinkMap()
                .randomSitelinkWithDescription();

        List<Long> ids = api.userSteps.sitelinksSteps().add(new AddRequestMap()
                .withSitelinksSets(
                        new SitelinksSetAddItemMap()
                                .withSitelinks(firstSitelinkMap),
                        new SitelinksSetAddItemMap()
                                .withSitelinks(secondSitelinkMap)));
        assumeThat("добавилось два набора сайтлинков", ids, hasSize(2));

        List<SitelinksSetGetItem> actualResult = api.userSteps.sitelinksSteps().get(ids);
        List<SitelinksSetGetItem> expected = Arrays.asList(
                        (SitelinksSetGetItem) new SitelinksSetGetItemMap()
                                .withSitelinks(firstSitelinkMap.asSitelinkGetMap())
                                .withId(ids.get(0)).getBean(),
                        (SitelinksSetGetItem) new SitelinksSetGetItemMap()
                                .withSitelinks(secondSitelinkMap.asSitelinkGetMap())
                                .withId(ids.get(1)).getBean());
        expected.sort(Comparator.comparingLong(SitelinksSetGetItem::getId));

        assertThat("набор сайтлинков сохранился верно", actualResult, beanEquivalent(expected));
    }
}
