package ru.yandex.autotests.directapi.sitelinks.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.sitelinks.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinksSetAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.utils.AccessRightsErrorHelper.checkCatchingJavaAccessError;

/**
 * Created by pavryabov on 21.04.16.
 * https://st.yandex-team.ru/TESTIRT-9088
 */
@Aqua.Test
@Features(SitelinksFeatures.ADD)
@Description("Проверка внутренних ролей. Позитивные сценарии")
@RunWith(Parameterized.class)
public class InternalRolesCheckRightsToAddTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String operator;

    @Parameterized.Parameter(2)
    public String client;

    @Parameterized.Parameter(3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameter(4)
    public Api5Error error;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {"менеджер - сервисируемый клиент",
                        Logins.MANAGER_DEFAULT, SitelinksLogins.SERV_CLIENT, ExpectedResult.success(), null},
                {"вешальщик - клиент",
                        Logins.PLACER, SitelinksLogins.CLIENT,
                        ExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE)),
                        new Api5Error(54)},
                {"саппорт - клиент",
                        Logins.SUPPORT, SitelinksLogins.CLIENT, ExpectedResult.success(), null},
                //DIRECT-55677
                {"супер - сервисируемый клиент",
                        Logins.SUPER_LOGIN, SitelinksLogins.SERV_CLIENT, ExpectedResult.success(), null},
                {"супер - клиент",
                        Logins.SUPER_LOGIN, SitelinksLogins.CLIENT, ExpectedResult.success(), null},
                {"менеджер - субклиент",
                        SitelinksLogins.MANAGER_DEFAULT, SitelinksLogins.SUB_CLIENT_WITH_EDIT_RIGHTS,
                        ExpectedResult.success(), null},
                {"супер - субклиент с правами редактирования",
                        Logins.SUPER_LOGIN, SitelinksLogins.SUB_CLIENT_WITH_EDIT_RIGHTS,
                        ExpectedResult.success(), null},
                {"супер - субклиент без прав редактирования",
                        Logins.SUPER_LOGIN, SitelinksLogins.SUB_CLIENT_WITHOUT_EDIT_RIGHTS,
                        ExpectedResult.success(), null}
        };
        return Arrays.asList(data);
    }

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(operator);
    }

    @Test
    public void checkRightsToAddSitelinks() {
        checkCatchingJavaAccessError(
                error,
                () -> api.as(Logins.SUPER_LOGIN, operator).userSteps.sitelinksSteps()
                        .shouldGetResultOnAdd(
                                client,
                                new AddRequestMap().withSitelinksSets(
                                        new SitelinksSetAddItemMap().defaultSitelinksSet(1)
                                ),
                                expectedResult
                        )
        );
    }
}
