package ru.yandex.autotests.directapi.sitelinks.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.sitelinks.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinksSetAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 21.04.16.
 * https://st.yandex-team.ru/TESTIRT-9088
 */
@Aqua.Test
@Features(SitelinksFeatures.ADD)
@Description("Проверка внутренних ролей. Негативные сценарии")
@RunWith(Parameterized.class)
public class InternalRolesNegativeTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String operator;

    @Parameterized.Parameter(2)
    public String client;

    @Parameterized.Parameter(3)
    public Api5Error expectedError;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                //DIRECT-55090
                {"медиапланер - клиент",
                        Logins.MEDIA, SitelinksLogins.CLIENT,
                        new Api5Error(54)},
                {"суперридер - клиент",
                        Logins.SUPER_READER, SitelinksLogins.CLIENT,
                        new Api5Error(54)},
                {"менеджер - клиент",
                        Logins.MANAGER_DEFAULT, SitelinksLogins.CLIENT,
                        new Api5Error(8800, Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN)},
        };
        return Arrays.asList(data);
    }

    @Before
    public void createGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(operator);
    }

    @Test
    public void checkRightsToAddSitelinks() {
        //DIRECT-53552
        api.as(operator).userSteps.sitelinksSteps().expectErrorOnAdd(client,
                new AddRequestMap()
                        .withSitelinksSets(new SitelinksSetAddItemMap()
                                .defaultSitelinksSet(1)),
                expectedError
        );
    }
}
