package ru.yandex.autotests.directapi.sitelinks.delete;

import java.util.Arrays;

import org.apache.commons.lang.ArrayUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.sitelinks.DeleteRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 2/6/15.
 * https://st.yandex-team.ru/TESTIRT-4101
 */
@Aqua.Test
@Features(SitelinksFeatures.DELETE)
@Description("Проверка ограничений на число удаляемых наборов сайтлинков за один запрос")
@Tag(TagDictionary.TRUNK)
public class DeleteIdsLengthRestrictionTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SitelinksLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToUser() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SitelinksLogins.CLIENT);
    }

    @Test
    @Description("Удалить " + IdsCriteriaMap.SITELINKS_IDS_MAX_LENGTH + " наборов сайтлинков за один запрос")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3844")
    public void maxIdsInDeleteRequest() {
        Long[] ids = ArrayUtils.toObject(new long[IdsCriteriaMap.SITELINKS_IDS_MAX_LENGTH]);
        ExpectedResult[] expectedResults = new ExpectedResult[IdsCriteriaMap.SITELINKS_IDS_MAX_LENGTH];
        Arrays.fill(expectedResults, ExpectedResult.errors(new Notification(9800, Api5ErrorDetails.SITELINKS_SET, 0)));

        api.userSteps.sitelinksSteps().shouldGetResultOnDelete(new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(ids)),
                expectedResults);
    }

    @Test
    @Description("Удалить наборы сайтлинков, число которых больше "
            + IdsCriteriaMap.SITELINKS_IDS_MAX_LENGTH + " за один запрос")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3845")
    public void greaterThanMaxInDeleteRequest() {
        Long[] ids = ArrayUtils.toObject(new long[IdsCriteriaMap.SITELINKS_IDS_MAX_LENGTH + 1]);

        api.userSteps.sitelinksSteps().expectErrorOnDelete(new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(ids)),
                new Api5Error(4001,
                        Api5ErrorDetailsJava.ENABLE_DELETE_NO_MORE_SITELINKS_FOR_OPERATION,
                        IdsCriteriaMap.SITELINKS_IDS_MAX_LENGTH)
        );
    }
}
