package ru.yandex.autotests.directapi.sitelinks.delete;

import org.json.simple.JSONObject;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.DeleteRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by semkagtn on 2/9/15.
 * https://st.yandex-team.ru/TESTIRT-4101
 */
@Aqua.Test
@Features(SitelinksFeatures.DELETE)
@Stories(ApiStories.JSON5)
@Description("Валидация JSON-запроса при удалении сайтлинков")
public class DeleteJsonValidationTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().protocol(ProtocolType.JSON).as(SitelinksLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToUser() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SitelinksLogins.CLIENT);
    }

    @Test
    @Description("Массив в поле SelectionCriteria")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3846")
    public void arrayInSelectionCriteriaField() {
        JSONObject request = new JSONObject();
        Object selectionCriteria = new IdsCriteriaMap()
                .withIds(0L).getBean();
        request.put(path(DeleteRequestMap.SELECTION_CRITERIA), new Object[]{selectionCriteria});
        api.userSteps.sitelinksSteps().expectErrorOnDelete(request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(DeleteRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    @Description("Не массив в поле SelectionCriteria.Ids")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3847")
    public void notAnArrayInIdsField() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(path(IdsCriteriaMap.IDS), 0L);
        request.put(path(DeleteRequestMap.SELECTION_CRITERIA), selectionCriteria);
        api.userSteps.sitelinksSteps().expectErrorOnDelete(request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(DeleteRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS)));
    }

    @Test
    @Description("Строка внутри массива SelectionCriteria.Ids")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3848")
    public void stringInIdsArray() {
        String value = "WrongId";
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(path(IdsCriteriaMap.IDS), new String[]{value});
        request.put(path(DeleteRequestMap.SELECTION_CRITERIA), selectionCriteria);
        api.userSteps.sitelinksSteps().expectErrorOnDelete(request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                        path(DeleteRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS)));
    }

    @Test
    @Description("Массив внутри массива SelectionCriteria.Ids")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3849")
    public void arrayInIdsArray() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(path(IdsCriteriaMap.IDS), new Long[][]{new Long[]{0L}});
        request.put(path(DeleteRequestMap.SELECTION_CRITERIA), selectionCriteria);
        api.userSteps.sitelinksSteps().expectErrorOnDelete(request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                        path(DeleteRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS)));
    }
}
