package ru.yandex.autotests.directapi.sitelinks.delete;

import com.yandex.direct.api.v5.sitelinks.SitelinksSetGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.sitelinks.DeleteRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.List;

import static org.hamcrest.collection.IsEmptyCollection.empty;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by semkagtn on 2/5/15.
 * https://st.yandex-team.ru/TESTIRT-4101
 */
@Aqua.Test
@Features(SitelinksFeatures.DELETE)
@Description("Проверка удаления сайтлинков, когда в запросе присутствуют валидный и невалидный объекты")
@Tag(TagDictionary.TRUNK)
public class DeleteMultipleErrorTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SitelinksLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private long id;
    private DeleteRequestMap deleteRequestMap;

    @Before
    @Step("Подготовка данных для теста")
    public void createSitelinksSet() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SitelinksLogins.CLIENT);
        id = api.userSteps.sitelinksSteps().addDefaultSet(1);
        long nonexistentId = id + 100000;
        deleteRequestMap = new DeleteRequestMap()
                .withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(id, nonexistentId));
    }

    @Test
    @Description("Вызвать метод удаления наборов сайтлинков для существующего и" +
            " несуществующего наборов и проверить ответ")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3852")
    public void deleteExistentAndNonexistentSitelinksSetsResponse() {
        api.userSteps.sitelinksSteps().shouldGetResultOnDelete(deleteRequestMap,
                ExpectedResult.success(id),
                ExpectedResult.errors(new Notification(8800)));
    }

    @Test
    @Description("Удалить валидный и невалидный наборы сайтлинков и проверить то, что первый удалился")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3853")
    public void deleteExistentAndNonexistentSitelinksSets() {
        api.userSteps.sitelinksSteps().delete(deleteRequestMap);
        List<SitelinksSetGetItem> result = api.userSteps.sitelinksSteps().get(id);
        assertThat("набор сайтлинков удалился успешно", result, empty());
    }
}
