package ru.yandex.autotests.directapi.sitelinks.delete;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.DeleteRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 30.06.16.
 */
@Aqua.Test
@Features(SitelinksFeatures.DELETE)
@Description("Неуспешное удаление сайтлинков от имени разных ролей")
@RunWith(Parameterized.class)
public class DeleteRolesNegativeTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String apiUserLogin;

    @Parameterized.Parameter(2)
    public String login;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Удаление сайтлинков от имени медиапланера", Logins.MEDIA, SitelinksLogins.CLIENT},

                {"Удаление сайтлинков от имени суперридера", Logins.SUPER_READER, SitelinksLogins.CLIENT},
        });
    }

    private long id;

    @Before
    @Step("Подготовка данных для теста")
    public void addUnitsToUser() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(apiUserLogin);
        api.as(Logins.SUPER_LOGIN);
        id = api.userSteps.sitelinksSteps().addDefaultSet(login, 1);
    }

    @Test
    public void deleteSitelinksSetWithInternalRoleLogin() {
        api.as(apiUserLogin);
        api.userSteps.sitelinksSteps().expectErrorOnDelete(login, new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(id)),
                new Api5Error(54));
    }
}
