package ru.yandex.autotests.directapi.sitelinks.delete;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.sitelinks.DeleteRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.utils.AccessRightsErrorHelper.checkCatchingJavaAccessError;

/**
 * Created by semkagtn on 2/6/15.
 * https://st.yandex-team.ru/TESTIRT-4101
 */
@Aqua.Test
@Features(SitelinksFeatures.DELETE)
@Description("Успешное удаление сайтлинков от имени разных ролей")
@RunWith(Parameterized.class)
public class DeleteRolesTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String apiUserLogin;

    @Parameterized.Parameter(2)
    public String login;

    @Parameterized.Parameter(3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameter(4)
    public Api5Error error;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Удаление сайтлинков от имени менеджера", Logins.MANAGER_DEFAULT, SitelinksLogins.SERV_CLIENT,
                        ExpectedResult.success(), null},

                {"Удаление сайтлинков от имени вешальщика", Logins.PLACER, SitelinksLogins.CLIENT,
                        ExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE)),
                        new Api5Error(54)},

                {"Удаление сайтлинков от имени саппорта", Logins.SUPPORT, SitelinksLogins.CLIENT,
                        ExpectedResult.success(), null},

                {"Удаление сайтлинков от имени супера", Logins.SUPER_LOGIN, SitelinksLogins.CLIENT,
                        ExpectedResult.success(), null},
                {"Удаление сайтлинков от имени клиента для самого себя",
                        SitelinksLogins.CLIENT, SitelinksLogins.CLIENT,
                        ExpectedResult.success(), null},

                {"Удаление сайтлинков от имени представителя клиента для клиента",
                        SitelinksLogins.CLIENT_REP, SitelinksLogins.CLIENT,
                        ExpectedResult.success(), null},
        });
    }

    private long id;

    @Before
    @Step("Подготовка данных для теста")
    public void addUnitsToUser() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(apiUserLogin);
        api.as(Logins.SUPER_LOGIN);
        id = api.userSteps.sitelinksSteps().addDefaultSet(login, 1);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3854")
    public void deleteSitelinksSetWithInternalRoleLogin() {
        api.as(apiUserLogin);
        checkCatchingJavaAccessError(
                error,
                () -> api.userSteps.sitelinksSteps().shouldGetResultOnDelete(
                        login,
                        new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(id)),
                        expectedResult
                )
        );
    }
}
