package ru.yandex.autotests.directapi.sitelinks.delete;

import com.yandex.direct.api.v5.sitelinks.SitelinksSetGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.sitelinks.DeleteRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.List;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by semkagtn on 2/6/15.
 * https://st.yandex-team.ru/TESTIRT-4101
 */
@Aqua.Test
@Features(SitelinksFeatures.DELETE)
@Description("Одинаковые идетификаторы в запросе на удаление наборов сайтлинков")
@Tag(TagDictionary.TRUNK)
public class DeleteSameIdsTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SitelinksLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private long id;

    @Before
    @Step("Подготовка данных для теста")
    public void addUnitsToUser() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SitelinksLogins.CLIENT);
        id = api.userSteps.sitelinksSteps().addDefaultSet(1);
    }

    @Test
    @Description("Одинаковые идетификаторы в запросе на удаление наборов сайтлинков должны возвращать ошибки")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3855")
    public void deleteSameIdsResponseTest() {
        api.userSteps.sitelinksSteps().shouldGetResultOnDelete(new DeleteRequestMap()
                .withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(id, id)),
                ExpectedResult.errors(new Notification(9800, Api5ErrorDetails.SITELINKS_SET, id)),
                ExpectedResult.errors(new Notification(9800, Api5ErrorDetails.SITELINKS_SET, id)));
    }

    @Test
    @Description("Сайтлинки с одинаковыми идентификаторами в запросе не должны быть удалены")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3856")
    public void deleteSameIdsTest() {
        api.userSteps.sitelinksSteps().delete(id, id);
        List<SitelinksSetGetItem> sitelinks = api.userSteps.sitelinksSteps().get(id);
        assertThat("сайтлинк не был удалён", sitelinks, hasSize(1));
    }
}

