package ru.yandex.autotests.directapi.sitelinks.delete;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.sitelinks.DeleteRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 2/6/15.
 * https://st.yandex-team.ru/TESTIRT-4101
 */
@Aqua.Test
@Features(SitelinksFeatures.DELETE)
@Description("Удалить сайтлинки субклиента от имени агенства, созданные другим агенством")
public class DeleteSitelinksSetWithAgencyLoginCreatedByAgencyTest {

    private static final String SUBCLIENT = SitelinksLogins.SUBCLIENT;
    private static final String SUBCLIENT_ELSE = SitelinksLogins.SUBCLIENT_HAS_RIGHTS;
    private static final String FIRST_AGENCY = SitelinksLogins.AGENCY;
    private static final String SECOND_AGENCY = SitelinksLogins.AGENCY_2;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private long id;

    @Before
    @Step("Подготовка данных для теста")
    public void createSitelinksSet() {
        api.as(Logins.SUPER_LOGIN);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(FIRST_AGENCY);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SECOND_AGENCY);

        api.as(FIRST_AGENCY);
        id = api.userSteps.sitelinksSteps().addDefaultSet(SUBCLIENT, 1);
    }

    @Test
    @Description("Удалить сайтлинки субклиента от имени агенства, созданные другим агенством")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3857")
    public void deleteSitelinksSetWithAgencyLoginCreatedByAnotherAgency() {
        api.as(SECOND_AGENCY);
        api.userSteps.sitelinksSteps().shouldGetErrorOn(ServiceNames.SITELINKS, SUBCLIENT, Action.GET,
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(id)),
                new Api5Error(8800, Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN));
    }

    @Test
    @Title("DIRECT-48813")
    @Description("Удалить сайтлинки субклиента от имени агенства для другого субклиента")
    public void deleteSitelinksSetWithAgencyLoginCreatedForAnotherSubClient() {
        api.as(FIRST_AGENCY);
        api.userSteps.sitelinksSteps().shouldGetResultOnDelete(SUBCLIENT_ELSE, new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(id)),
                ExpectedResult.errors(new Notification(8800)));
    }
}
