package ru.yandex.autotests.directapi.sitelinks.delete;

import com.yandex.direct.api.v5.sitelinks.SitelinksSetFieldEnum;
import com.yandex.direct.api.v5.sitelinks.SitelinksSetGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinksSetGetItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.List;

import static org.hamcrest.Matchers.empty;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by semkagtn on 2/5/15.
 * https://st.yandex-team.ru/TESTIRT-4101
 */
@Aqua.Test
@Features(SitelinksFeatures.DELETE)
@Description("Проверки удаления наборов сайтлинков")
@Tag(TagDictionary.TRUNK)
public class DeleteTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SitelinksLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private long firstId;
    private long secondId;

    @Before
    @Step("Подготовка данных для теста")
    public void createSitelinksSets() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SitelinksLogins.CLIENT);
        firstId = api.userSteps.sitelinksSteps().addDefaultSet(1);
        secondId = api.userSteps.sitelinksSteps().addDefaultSet(1);
    }

    @Test
    @Description("Проверить ответ при удалении одного сайтлинка за один запрос")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3861")
    public void deleteOneSitelinksSetResponse() {
        api.userSteps.sitelinksSteps().shouldGetResultOnDelete(new DeleteRequestMap()
                .withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(firstId)),
                ExpectedResult.success(firstId));
    }

    @Test
    @Description("Проверить корректность удаления одного набора сайтлинков за один запрос")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3862")
    public void deleteOneSitelinksSet() {
        api.userSteps.sitelinksSteps().delete(firstId);

        List<SitelinksSetGetItem> result = api.userSteps.sitelinksSteps().get(new GetRequestMap()
                .withFieldNames(SitelinksSetFieldEnum.ID)
                .withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(firstId, secondId)));

        assertThat("один сайтлинк был удалён", result, beanEquivalent(Arrays.asList(
                (SitelinksSetGetItem) new SitelinksSetGetItemMap()
                        .withId(secondId).getBean())));
    }

    @Test
    @Description("Проверить ответ при удалении двух сайтлинков за один запрос")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3863")
    public void deleteTwoSitelinksSetsResponse() {
        api.userSteps.sitelinksSteps().shouldGetResultOnDelete(new DeleteRequestMap()
                .withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(firstId, secondId)),
                ExpectedResult.success(firstId), ExpectedResult.success(secondId));
    }

    @Test
    @Description("Проверить корректность удаления двух наборов сайтлинков за один запрос")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3864")
    public void deleteTwoSitelinksSets() {
        api.userSteps.sitelinksSteps().delete(firstId, secondId);

        List<SitelinksSetGetItem> result = api.userSteps.sitelinksSteps().get(firstId, secondId);

        assertThat("два сайтлинка были удалены", result, empty());
    }
}
