package ru.yandex.autotests.directapi.sitelinks.delete;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.sitelinks.DeleteRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 12.05.15.
 * https://st.yandex-team.ru/TESTIRT-5451
 */
@Aqua.Test
@Features(SitelinksFeatures.DELETE)
@Description("Попытка удаления использованного набора быстрых ссылок")
public class DeleteUsedSitelinksSetTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SitelinksLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private long sitelinksSetID;
    private Long campaignID;

    @Before
    @Step("Подготовка данных для теста")
    public void createSitelinksSet() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SitelinksLogins.CLIENT);

        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(SitelinksLogins.CLIENT);
        long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        sitelinksSetID = api.userSteps.sitelinksSteps().addDefaultSet(1);
        api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(adGroupID)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withSitelinkSetId(sitelinksSetID)));
    }

    @Test
    @Description("Попытка удалить привязанный набор сайтлинков")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3872")
    public void deleteUsedSitelinksSet() {
        api.userSteps.sitelinksSteps().shouldGetResultOnDelete(new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(sitelinksSetID)),
                ExpectedResult.errors(
                        new Notification(6000, Api5ErrorDetailsJava.SITELINKS_SET_USED_AND_CANT_BE_DELETED)));
    }

    @Test
    @Description("Попытка удалить привязанный набор сайтлинков, когда кампания удалена")
    @Issue("https://st.yandex-team.ru/DIRECT-42259")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3873")
    public void deleteUsedSitelinksWhenCampaignDeleted() {
        api.userSteps.campaignSteps().campaignsDelete(campaignID);
        api.userSteps.sitelinksSteps().shouldGetResultOnDelete(new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(sitelinksSetID)),
                ExpectedResult.success(sitelinksSetID));
    }
}
