package ru.yandex.autotests.directapi.sitelinks.delete;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.sitelinks.DeleteRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

/**
 * Created by semkagtn on 2/6/15.
 * https://st.yandex-team.ru/TESTIRT-4101
 */
@Aqua.Test
@Features(SitelinksFeatures.DELETE)
@Description("Запрос на удаление невалидных идентификаторов наборов сайтлинков")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class DeleteWrongIdsTest {

    private static final String LOGIN = SitelinksLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public long wrongId;

    @Parameterized.Parameters(name = "{0} - {1}")
    public static Collection<Object[]> data() {
        long id = api.userSteps.sitelinksSteps().addDefaultSet(1);
        long nonexistentId = id + 100000;
        long deletedId = api.userSteps.sitelinksSteps().addDefaultSet(1);
        api.userSteps.sitelinksSteps().delete(deletedId);

        long foreignId = api.as(SitelinksLogins.SERV_CLIENT).userSteps.sitelinksSteps().addDefaultSet(1);
        api.as(LOGIN);

        return Arrays.asList(new Object[][]{
                {"нулевой идетификатор в запросе на удаление наборов сайтлинков", 0},
                {"отрицательный идетификатор в запросе на удаление наборов сайтлинков", -1},
                {"несуществующий идетификатор в запросе на удаление наборов сайтлинков", nonexistentId},
                {"удалённый идетификатор в запросе на удаление наборов сайтлинков", deletedId},
                {"чужой идентификатор в запросе на удаление наборов сайтлинков", foreignId},
        });
    }

    @Before
    public void addUnitsToUser() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3874")
    public void wrongIdInDeleteRequest() {
        api.userSteps.sitelinksSteps().shouldGetResultOnDelete(new DeleteRequestMap()
                .withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(wrongId)),
                ExpectedResult.errors(new Notification(8800)));
    }
}
