package ru.yandex.autotests.directapi.sitelinks.get;

import java.util.List;

import com.yandex.direct.api.v5.sitelinks.SitelinksSetGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.sitelinks.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinkMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinksSetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinksSetGetItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Arrays.asList;
import static org.hamcrest.Matchers.containsInAnyOrder;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static org.hamcrest.core.IsNot.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by onotole on 29.06.16.
 * https://st.yandex-team.ru/TESTIRT-9633
 */

@Aqua.Test
@Features(SitelinksFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-55470")
@Description("Проверка двух разных наборов, отличающихся только описаниями")
@Tag(TagDictionary.TRUNK)
public class Get2DifferentDescriptionTest {
    private static long firstId;
    private static long secondId;
    private static SitelinkMap sitelinkMap1;
    private static SitelinkMap sitelinkMap2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SitelinksLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void createSitelinksSets() {
        String firstDescription = "First random description";
        String secondDescription = "Second random description";
        String sitelinkTitle = "Random title";
        String sitelinkHref = "http://random.sitelink.ru";

        sitelinkMap1 = new SitelinkMap().withTitle(sitelinkTitle).withHref(sitelinkHref)
                .withDescription(firstDescription);
        sitelinkMap2 = new SitelinkMap().withTitle(sitelinkTitle).withHref(sitelinkHref)
                .withDescription(secondDescription);

        List<Long> ids = api.userSteps.sitelinksSteps().add(new AddRequestMap()
                .withSitelinksSets(
                        new SitelinksSetAddItemMap()
                                .withSitelinks(sitelinkMap1),
                        new SitelinksSetAddItemMap()
                                .withSitelinks(sitelinkMap2)));

        assumeThat("оба набора sitelinks добавились", ids, hasSize(2));
        firstId = ids.get(0);
        secondId = ids.get(1);
    }

    @Test
    public void testTwoSitelinkSetsWithDifferentDescriptions() {
        assertThat("сайтлинки сохранились с разными id", firstId, not(equalTo(secondId)));

        List<SitelinksSetGetItem> result = api.userSteps.sitelinksSteps().get(firstId, secondId);
        assertThat("сайтлинки сохранились верно", result, containsInAnyOrder(asList(
                beanDiffer((SitelinksSetGetItem) new SitelinksSetGetItemMap()
                        .withSitelinks(sitelinkMap1.asSitelinkGetMap()).withId(firstId).getBean()),
                beanDiffer((SitelinksSetGetItem) new SitelinksSetGetItemMap()
                        .withSitelinks(sitelinkMap2.asSitelinkGetMap()).withId(secondId).getBean())
        )));
    }
}
