package ru.yandex.autotests.directapi.sitelinks.get;

import com.yandex.direct.api.v5.sitelinks.SitelinksSetGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by semkagtn on 2/3/15.
 * https://st.yandex-team.ru/TESTIRT-4099
 */
@Aqua.Test
@Features(SitelinksFeatures.GET)
@Description("Проверка игнорирования некоторых идентификаторов наборов сайтлинков")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetIgnoringOfIdsTest {

    private static final String LOGIN = SitelinksLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static long id;
    private static long deletedId;
    private static long nonexistentId;
    private static long foreignId;

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public long ignoringId;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        id = api.userSteps.sitelinksSteps().addDefaultSet(1);
        deletedId = api.userSteps.sitelinksSteps().addDefaultSet(1);
        api.userSteps.sitelinksSteps().delete(deletedId);
        nonexistentId = id + 100000;

        foreignId = api.as(SitelinksLogins.SERV_CLIENT).userSteps.sitelinksSteps().addDefaultSet(1);
        api.as(LOGIN);

        return Arrays.asList(new Object[][]{
                {"Повторный идентификтор набора сайтлинков игнорируется", id},
                {"Удалённый идентификтор набора сайтлинков игнорируется", deletedId},
                {"Несуществующий идентификтор набора сайтлинков игнорируется", nonexistentId},
                {"Нулевой идентификтор набора сайтлинков игнорируется", 0},
                {"Отрицательный идентификтор набора сайтлинков игнорируется", -1},
                {"Чужой идентификатор набора сайтлинков игнорируется", foreignId},
        });
    }

    @Before
    public void addUnitsToUser() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3879")
    public void validAndInvalidIdInRequest() {
        List<SitelinksSetGetItem> result = api.userSteps.sitelinksSteps().get(id, ignoringId);
        assertThat("второй идентификтор был проигнорирован", result, hasSize(1));
    }
}
