package ru.yandex.autotests.directapi.sitelinks.get;

import com.yandex.direct.api.v5.sitelinks.SitelinksSetGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.List;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.collection.IsEmptyCollection.empty;

/**
 * Created by semkagtn on 24.03.15.
 * https://st.yandex-team.ru/TESTIRT-4099
 */
@Aqua.Test
@Features(SitelinksFeatures.GET)
@Description("Получение наборов сайтлинков при невалидном идентификаторе в запросе")
@Tag(TagDictionary.TRUNK)
public class GetInvalidIdTest {

    private static final String LOGIN = SitelinksLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToUser() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Отрицательный идентификатор в запросе на получение наборов сайтлинков")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3880")
    public void negativeIdInRequest() {
        List<SitelinksSetGetItem> result = api.userSteps.sitelinksSteps().get(Arrays.asList(-1l));
        assertThat("не вернулось ни одного набора сайтлинков", result, empty());
    }
}
