package ru.yandex.autotests.directapi.sitelinks.get;

import com.yandex.direct.api.v5.sitelinks.SitelinkFieldEnum;
import com.yandex.direct.api.v5.sitelinks.SitelinksSetFieldEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.MUTUALLY_EXCLUSIVE_PARAMETERS;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by semkagtn on 2/4/15.
 * https://st.yandex-team.ru/TESTIRT-4099
 */
@Aqua.Test
@Features(SitelinksFeatures.GET)
@Description("Проверка обязательных полей в запросе для получения сайтлинков")
@Tag(TagDictionary.TRUNK)
public class GetMandatoryFieldsTest {

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(SitelinksLogins.CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToUser() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SitelinksLogins.CLIENT);
    }

    @Test
    @Description("Запрос на получение сайтлинков без поля SelectionCriteria.Ids")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3894")
    public void requestWithoutIdsField() {
        api.userSteps.sitelinksSteps().expectErrorOnGet(new GetRequestMap()
                .withFieldNames(SitelinksSetFieldEnum.ID)
                .withSelectionCriteria(new IdsCriteriaMap()),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(IdsCriteriaMap.IDS)));
    }

    @Test
    @Description("Запрос на получение сайтлинков без поля FieldNames")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3895")
    public void requestWithoutFieldNames() {
        api.userSteps.sitelinksSteps().expectErrorOnGet(new GetRequestMap(),
                new Api5Error(5008, Api5ErrorDetailsJava.ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
                        "FieldNames, SitelinkFieldNames"));
    }

    @Test
    @Description("Запрос на получение сайтлинков с одновременным указанием Sitelinks в FieldNames и SitelinkFieldNames")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3896")
    public void requestWithSitelinksAndSitelinkFieldnames() {
        //Ожидаем "Параметр SitelinkFieldNames несовместим со значением Sitelinks в параметре FieldNames"
        api.userSteps.sitelinksSteps().expectErrorOnGet(
                new GetRequestMap()
                        .withFieldNames(SitelinksSetFieldEnum.SITELINKS)
                        .withSitelinkFieldNames(SitelinkFieldEnum.HREF),
                new Api5Error(4004,
                        Api5ErrorDetailsJava.SITELINKS_WITH_SITELINK_FIELD_NAMES_PROHIBITED,
                        "SitelinkFieldNames", "Sitelinks", "FieldNames")
                        .withMessageFromResource(MUTUALLY_EXCLUSIVE_PARAMETERS));
    }
}
