package ru.yandex.autotests.directapi.sitelinks.get;

import com.yandex.direct.api.v5.sitelinks.SitelinksSetFieldEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.general.LimitOffsetMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 2/6/15.
 * https://st.yandex-team.ru/TESTIRT-4099
 */
@Aqua.Test
@Features(SitelinksFeatures.GET)
@Description("Проверка ограничений на параметр смещения при получении сайтлинков")
@Tag(TagDictionary.TRUNK)
public class GetOffsetRestrictionTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SitelinksLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToUser() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SitelinksLogins.CLIENT);
    }

    @Test
    @Description("Нулевое значение смещения при получении сайтлинков")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3896")
    public void getSitelinksWithZeroOffsetValue() {
        api.userSteps.sitelinksSteps().get(new GetRequestMap()
                .withFieldNames(SitelinksSetFieldEnum.ID)
                .withPage(new LimitOffsetMap()
                        .withOffset(0l)));
    }

    @Test
    @Description("Отрицательное значение смещения при получении сайтлинков")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3897")
    public void getSitelinksWithNegativeOffsetValue() {
        api.userSteps.sitelinksSteps().expectErrorOnGet(new GetRequestMap()
                .withFieldNames(SitelinksSetFieldEnum.ID)
                .withPage(new LimitOffsetMap()
                        .withOffset(-1l)),
                new Api5Error(4002, Api5ErrorDetails.OFFSET_MUST_BE_MORE_OR_EQUAL_THAN_0));
    }
}
