package ru.yandex.autotests.directapi.sitelinks.get;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 2/5/15.
 * https://st.yandex-team.ru/TESTIRT-4099
 */
@Aqua.Test
@Features(SitelinksFeatures.GET)
@Description("Получение сайтлинков от имени разных ролей, негативные сценарии")
public class GetRolesNegativeTest {

    private static final String SUBCLIENT = SitelinksLogins.SUBCLIENT;
    private static final String FIRST_AGENCY = SitelinksLogins.AGENCY;
    private static final String SECOND_AGENCY = SitelinksLogins.AGENCY_2;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private long id;

    @Before
    @Step("Подготовка данных для теста")
    public void createSitelinksSet() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SitelinksLogins.CLIENT);
        api.as(FIRST_AGENCY);
        id = api.userSteps.sitelinksSteps().addDefaultSet(SUBCLIENT, 1);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3899")
    public void getSitelinksOfSubclientCreatedByAnotherAgency() {
        api.as(SECOND_AGENCY);
        api.userSteps.sitelinksSteps().shouldGetErrorOn(ServiceNames.SITELINKS, SUBCLIENT, Action.GET,
                new GetRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(id)),
                new Api5Error(8800, Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN));
    }
}
