package ru.yandex.autotests.directapi.sitelinks.get;

import com.yandex.direct.api.v5.sitelinks.SitelinksSetFieldEnum;
import com.yandex.direct.api.v5.sitelinks.SitelinksSetGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.sitelinks.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by semkagtn on 2/4/15.
 * https://st.yandex-team.ru/TESTIRT-4099
 */
@Aqua.Test
@Features(SitelinksFeatures.GET)
@Description("Получение сайтлинков от имени разных ролей")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetRolesTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String apiUserLogin;

    @Parameterized.Parameter(2)
    public String login;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Получение сайтлинков от имени менеджера", Logins.MANAGER_DEFAULT, SitelinksLogins.SERV_CLIENT},

                {"Получение сайтлинков от имени вешальщика", Logins.PLACER, SitelinksLogins.CLIENT},

                {"Получение сайтлинков от имени саппорта", Logins.SUPPORT, SitelinksLogins.CLIENT},

                {"Получение сайтлинков от имени супера", Logins.SUPER_LOGIN, SitelinksLogins.CLIENT},

                {"Получение сайтлинков от имени медиапланера", Logins.MEDIA, SitelinksLogins.CLIENT},

                {"Получение сайтлинков от имени суперридера", Logins.SUPER_READER, SitelinksLogins.CLIENT},

                {"Получение сайтлинков клиента от имени самого себя",
                        SitelinksLogins.CLIENT, SitelinksLogins.CLIENT},

                {"Получение сайтлинков клиента от имени представителя",
                        SitelinksLogins.CLIENT_REP, SitelinksLogins.CLIENT},

                {"Получение сайтлинков субклиента от имени агенства",
                        SitelinksLogins.AGENCY, SitelinksLogins.SUBCLIENT_HAS_RIGHTS},

                {"Получение сайтлинков субклиента от имени самого себя",
                        SitelinksLogins.SUBCLIENT_HAS_RIGHTS, SitelinksLogins.SUBCLIENT_HAS_RIGHTS}
        });
    }

    @Before
    public void addUnitsToUser() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(apiUserLogin);

        api.as(Logins.SUPER_LOGIN);
        api.userSteps.sitelinksSteps().addDefaultSet(login, 1);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3898")
    public void addSitelinksSetWithInternalRoleLogin() {
        api.as(apiUserLogin);
        List<SitelinksSetGetItem> sitelinks = api.userSteps.sitelinksSteps().get(login, new GetRequestMap()
                .withFieldNames(SitelinksSetFieldEnum.ID));
        assertThat("сайтлинки вернулись успешно", sitelinks, not(empty()));
    }
}
