package ru.yandex.autotests.directapi.sitelinks.get;

import java.util.List;

import com.yandex.direct.api.v5.sitelinks.SitelinksSetFieldEnum;
import com.yandex.direct.api.v5.sitelinks.SitelinksSetGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.sitelinks.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by semkagtn on 12.05.15.
 * https://st.yandex-team.ru/TESTIRT-4099
 */
@Aqua.Test
@Features(SitelinksFeatures.GET)
@Description("Запросы на получение наборов сайтлинков по протоколу SOAP")
public class GetSoapTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SitelinksLogins.CLIENT).protocol(ProtocolType.SOAP);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToUser() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SitelinksLogins.CLIENT);
    }

    @Test
    @Description("Запрос на получение сайтлинков без поля FieldNames")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3902")
    public void requestWithoutFieldNames() {
        api.userSteps.sitelinksSteps().expectErrorOnGet(new GetRequestMap(),
                new Api5Error(5008, Api5ErrorDetailsJava.ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
                        "FieldNames, SitelinkFieldNames"));
    }

    @Test
    @Description("Запрос на получение наборов сайтлинков с невалидным значением в FieldNames")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3900")
    public void invalidFieldNameInRequest() {
        String invalidFieldName = "SomeInvalidValue";
        api.userSteps.sitelinksSteps().expectErrorOnGet(new GetRequestMap()
                        .withFieldNames(invalidFieldName),
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        path(GetRequestMap.FIELD_NAMES),
                        Api5Error.enumAsParam(SitelinksSetFieldEnum.class)));
    }

    @Test
    @Description("Валидный запрос на получение наборов сайтлинков")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3903")
    public void sitelinksGet() {
        api.protocol(ProtocolType.JSON);
        long id = api.userSteps.sitelinksSteps().addDefaultSet(1);

        api.protocol(ProtocolType.SOAP);
        List<SitelinksSetGetItem> result = api.userSteps.sitelinksSteps().get(id);
        assertThat("вернулся один набор сайтлинков", result, hasSize(1));
    }
}
