package ru.yandex.autotests.directapi.sitelinks.get;

import com.yandex.direct.api.v5.sitelinks.SitelinksSetFieldEnum;
import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 2/9/15.
 * https://st.yandex-team.ru/TESTIRT-4099
 */
@Aqua.Test
@Features(SitelinksFeatures.GET)
@Stories(ApiStories.UNITS)
@Description("Снятие баллов клиента при получение наборов сайтлинков")
public class GetUnitsTest {

    private static final String LOGIN = SitelinksLogins.UNITS_GET_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final int CALL_COST = 15;
    private static final int SET_COST = 1;

    private static long firstId;
    private static long secondId;

    @BeforeClass
    public static void createSitelinksSet() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        firstId = api.userSteps.sitelinksSteps().addDefaultSet(1);
        secondId = api.userSteps.sitelinksSteps().addDefaultSet(1);
    }

    @Before
    public void addUnitsToUser() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Получение одного набора сайтлинков")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3907")
    public void getOneSitelinksSet() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        api.userSteps.sitelinksSteps().get(firstId);
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        int actualCost = unitsBefore - unitsAfter;
        int expectedCost = CALL_COST + SET_COST;
        assertThat("списалось верное число баллов", actualCost, equalTo(expectedCost));
    }

    @Test
    @Description("Получение двух наборов сайтлинков")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3908")
    public void getTwoSitelinksSets() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        api.userSteps.sitelinksSteps().get(firstId, secondId);
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        int actualCost = unitsBefore - unitsAfter;
        int expectedCost = CALL_COST + 2 * SET_COST;
        assertThat("списалось верное число баллов", actualCost, equalTo(expectedCost));
    }

    @Test
    @Description("Получение наборов сайтлинков при отсутствии баллов у клиента")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3909")
    public void getSitelinksSetsWhenClientHasZeroUnits() {
        int units = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        api.userSteps.clientFakeSteps().fakeWithdrawClientUnits(LOGIN, units);
        units = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        assumeThat("у клиента нету баллов", units, equalTo(0));

        api.userSteps.sitelinksSteps().expectErrorOnGet(new GetRequestMap()
                .withFieldNames(SitelinksSetFieldEnum.ID)
                .withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(firstId)),
                new Api5Error(152, Api5ErrorDetails.NOT_ENOUGH_UNITS_FOR_OPERATION));
    }
}
