package ru.yandex.autotests.directapi.sitelinks.get;

import java.util.List;

import com.yandex.direct.api.v5.sitelinks.SitelinksSetFieldEnum;
import com.yandex.direct.api.v5.sitelinks.SitelinksSetGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.sitelinks.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sitelinks.SitelinksFeatures;
import ru.yandex.autotests.directapi.sitelinks.SitelinksLogins;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.greaterThan;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by semkagtn on 24.03.15.
 * https://st.yandex-team.ru/TESTIRT-4099
 */
@Aqua.Test
@Features(SitelinksFeatures.GET)
@Description("Проверка получения сайтлинков клиента без использования критерия выбора")
public class GetWithoutSelectionCriteriaTest {

    private static final String MANAGER = Logins.MANAGER_DEFAULT;
    private static final String LOGIN = SitelinksLogins.SERV_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(MANAGER).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    @Step("Подготовка данных для теста")
    public void createSubClientWithSitelinks() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(MANAGER);
        api.userSteps.sitelinksSteps().addDefaultSet(LOGIN, 1);
    }

    @Test
    @Description("Проверка получения сайтлинков клиента без использования критерия выбора")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3910")
    public void getRequestWithoutSelectionCriteria() {
        List<SitelinksSetGetItem> result = api.userSteps.sitelinksSteps().get(LOGIN, new GetRequestMap()
                .withFieldNames(SitelinksSetFieldEnum.ID));
        assertThat("вернулся набор сайтлинков пользователя", result, hasSize(greaterThan(0)));
    }
}
