package ru.yandex.autotests.directapi.vcards;

import java.util.List;

import com.yandex.direct.api.v5.vcards.VCardGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.VCardsStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardGetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.irt.testutils.beandiffer.beanconstraint.BeanConstraints;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.greaterThan;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by chicos on 16.09.14.
 */
@Aqua.Test
@Features(VCardsFeatures.GET)
@Stories(VCardsStories.SHARDING)
public class VCardsShardingTest {
    private static LogSteps log = LogSteps.getLogger(VCardsShardingTest.class);

    private static String agencyShard2 = VCardsLogins.AGENCY_VCARDS_SHARD_2;
    private static String subClientShard1 = VCardsLogins.SUBCLIENT_VCARDS_SHARD_1;
    private static String subClientShard2 = VCardsLogins.SUBCLIENT_VCARDS_SHARD_2;

    private static Long campaignShard1;
    private static Long campaignShard2;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void prepareCampaign(){
        api.userSteps.clientFakeSteps().reshardUserWithLock(agencyShard2, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subClientShard1, ShardNumbers.DEFAULT_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subClientShard2, ShardNumbers.EXTRA_SHARD);

        log.info("Подготовим кампании");
        api.as(agencyShard2);
        campaignShard2 = api.userSteps.campaignSteps().addDefaultTextCampaign(subClientShard2);
        campaignShard1 = api.userSteps.campaignSteps().addDefaultTextCampaign(subClientShard1);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3913")
    public void vCardFromSameShardTest(){
        log.info("Создадим визитку во 2-м шарде");
        String companyName = "Компания 2-го шарда";
        Long vcardShard2 = api.userSteps.vCardsSteps().vCardsAdd(subClientShard2,
                new VCardAddMap()
                        .defaultContacts()
                        .withCompanyName(companyName)
                        .withCampaignId(campaignShard2)
        ).get(0);

        log.info("Запросим визитку 2-го шарда агентством 2-го шарда");
        List<VCardGetItem> vCards = api.userSteps.vCardsSteps().vCardsGet(subClientShard2, vcardShard2);

        assertThat("вернулся набор визиток", vCards.size(), greaterThan(0));
        assertThat("получена корректная визитка", vCards.toArray()[0],
                beanDifferV5(
                        new VCardGetMap()
                                .shortContacts()
                                .withCampaignId(campaignShard2)
                                .withCompanyName(companyName)
                                .getBean()
                ).fields(new BeanConstraints().only(VCardGetMap.shortFieldsSet()))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3914")
    public void vCardFromDifferentShardTest(){
        log.info("Создадим визитку в 1-м шарде");
        String companyName = "Компания 1-го шарда";
        Long vcardShard1 = api.userSteps.vCardsSteps().vCardsAdd(subClientShard1,
                new VCardAddMap()
                        .defaultContacts()
                        .withCompanyName(companyName)
                        .withCampaignId(campaignShard1)
        ).get(0);

        log.info("Запросим визитку 1-го шарда агентством 2-го шарда");
        List<VCardGetItem> vCards = api.userSteps.vCardsSteps().vCardsGet(subClientShard1, vcardShard1);

        assertThat("вернулся набор визиток", vCards.size(), greaterThan(0));
        assertThat("получена корректная визитка", vCards.toArray()[0],
                beanDifferV5(
                        new VCardGetMap()
                                .shortContacts()
                                .withCampaignId(campaignShard1)
                                .withCompanyName(companyName)
                                .getBean()
                ).fields(new BeanConstraints().only(VCardGetMap.shortFieldsSet()))
        );
    }
}
