package ru.yandex.autotests.directapi.vcards.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.vcards.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Author ginger
 * https://st.yandex-team.ru/TESTIRT-9520
 */
@Aqua.Test
@Features(VCardsFeatures.ADD)
@Issue("https://st.yandex-team.ru/DIRECT-44780")
@RunWith(Parameterized.class)
public class AddVCardNotSupportedCampaignTypeTest {
    private static String client = VCardsLogins.SINGLE_CLIENT;
    private static Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public CampaignsType campaignsType;

    @Parameterized.Parameter(1)
    public Notification error;

    @Parameterized.Parameters(name = "тип кампании - {0}")
    public static Collection testData() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Object[][] data = new Object[][]{
                {CampaignsType.GEO, new Notification(8800, Api5ErrorDetailsJava.CAMPAIGN_IN_DETAILS, campaignId)},
                {CampaignsType.MCB, new Notification(8800, Api5ErrorDetailsJava.CAMPAIGN_IN_DETAILS, campaignId)},
                {CampaignsType.MCBANNER, new Notification(8800, Api5ErrorDetailsJava.CAMPAIGN_IN_DETAILS, campaignId)},
                {CampaignsType.WALLET, new Notification(8800, Api5ErrorDetailsJava.CAMPAIGN_IN_DETAILS, campaignId)},
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        api.userSteps.campaignFakeSteps().setType(campaignId, campaignsType);
    }

    @Test
    public void tryAddVcardToCampaign() {
        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap()
                        .withVCards(
                                new VCardAddMap()
                                        .shortContacts()
                                        .withCampaignId(campaignId)),
                ExpectedResult.errors(error)
        );
    }
}
