package ru.yandex.autotests.directapi.vcards.add;

import java.util.Collection;

import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.vcards.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.PhoneMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Arrays.asList;
import static java.util.Collections.singletonList;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by chicos on 10.12.14.
 */
@Aqua.Test
@Features(VCardsFeatures.ADD)
@Stories(ApiStories.JSON5)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AddVCardsFieldTypesNegativeTest {

    private static final String singleClient = VCardsLogins.SINGLE_CLIENT;
    private Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(singleClient).protocol(ProtocolType.JSON);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public String fieldName;

    @Parameterized.Parameter(value = 2)
    public Object fieldValue;

    @Parameterized.Parameter(value = 3)
    public Api5Error expectedError;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection fields() {
        JSONObject foolishObject = new JSONObject();
        foolishObject.put("SomeFieldName", "Плюшевые пряники");
        Object[][] data = new Object[][]{
                {"required, Float to Integer", VCardAddMap.CAMPAIGN_ID, 2.13f, new Api5Error(8000,
                        Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD2,
                        path(AddRequestMap.VCARDS, VCardAddMap.CAMPAIGN_ID))},
                {"required, JSON to Integer", VCardAddMap.CAMPAIGN_ID, new JSONObject(), new Api5Error(8000,
                        Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                        path(AddRequestMap.VCARDS, VCardAddMap.CAMPAIGN_ID))},
                {"required, ARRAY to Integer", VCardAddMap.CAMPAIGN_ID, singletonList(123456), new Api5Error(8000,
                        Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(AddRequestMap.VCARDS, VCardAddMap.CAMPAIGN_ID))},
                {"required, JSON to String", VCardAddMap.COUNTRY, new JSONObject(), new Api5Error(8000,
                        Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_STRING,
                        path(AddRequestMap.VCARDS, VCardAddMap.COUNTRY))},
                {"required, ARRAY to String", VCardAddMap.COUNTRY, singletonList("Россия"), new Api5Error(8000,
                        Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(AddRequestMap.VCARDS, VCardAddMap.COUNTRY))},
                {"required, String to JSON", VCardAddMap.PHONE, "123-45-67", new Api5Error(8000,
                        Api5ErrorDetailsJava.INVALID_VALUE,
                        path(AddRequestMap.VCARDS, VCardAddMap.PHONE))},
                {"required, ARRAY to JSON", VCardAddMap.PHONE, singletonList("123-45-67"), new Api5Error(8000,
                        Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(AddRequestMap.VCARDS, VCardAddMap.PHONE))},
                {"optional, JSON to Integer", VCardAddMap.METRO_STATION_ID, new JSONObject(), new Api5Error(8000,
                        Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                        path(AddRequestMap.VCARDS, VCardAddMap.METRO_STATION_ID))},
                {"optional, ARRAY to Integer", VCardAddMap.METRO_STATION_ID, singletonList(123456), new Api5Error(8000,
                        Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(AddRequestMap.VCARDS, VCardAddMap.METRO_STATION_ID))},
                {"optional, JSON to String", VCardAddMap.BUILDING, foolishObject, new Api5Error(8000,
                        Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_STRING,
                        path(AddRequestMap.VCARDS, VCardAddMap.BUILDING))},
                {"optional, ARRAY to String", VCardAddMap.BUILDING, singletonList("27"), new Api5Error(8000,
                        Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(AddRequestMap.VCARDS, VCardAddMap.BUILDING))},
                {"optional, String to JSON", VCardAddMap.INSTANT_MESSENGER, "skype", new Api5Error(8000,
                        Api5ErrorDetailsJava.INVALID_VALUE,
                        path(AddRequestMap.VCARDS, VCardAddMap.INSTANT_MESSENGER))},
                {"optional, ARRAY to JSON", VCardAddMap.INSTANT_MESSENGER, singletonList("skype"), new Api5Error(8000,
                        Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(AddRequestMap.VCARDS, VCardAddMap.INSTANT_MESSENGER))},

                //https://st.yandex-team.ru/DIRECT-39278

                /*{"required, Float to String", VCardAddMap.COUNTRY, 2.13f, new Api5Error(8000,
                        Api5ErrorDetails.FIELD_MUST_CONTAIN_STRING,
                        StringUtils.capitalize(VCardAddMap.COUNTRY))},
                {"optional, Float to String", VCardAddMap.BUILDING, 2.13f, new Api5Error(8000,
                        Api5ErrorDetails.FIELD_MUST_CONTAIN_STRING,
                        StringUtils.capitalize(VCardAddMap.BUILDING))}*/
        };
        return asList(data);
    }

    @Before
    public void prepareCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3915")
    public void invalidRequiredFieldTypeTest() {
        JSONObject vcard = getShortContacts();
        vcard.put(StringUtils.capitalize(VCardAddMap.CAMPAIGN_ID), campaignId);
        vcard.put(StringUtils.capitalize(fieldName), fieldValue);

        JSONObject request = new JSONObject();
        request.put("VCards", asList(vcard));

        api.userSteps.vCardsSteps().shouldGetVCardErrorJsonOn(
                Action.ADD,
                request,
                expectedError
        );
    }

    private JSONObject getShortContacts() {
        JSONObject phone = new JSONObject();
        phone.put(StringUtils.capitalize(PhoneMap.COUNTRY_CODE), "+7");
        phone.put(StringUtils.capitalize(PhoneMap.CITY_CODE), "812");
        phone.put(StringUtils.capitalize(PhoneMap.PHONE_NUMBER), "123-45-67");
        phone.put(StringUtils.capitalize(PhoneMap.EXTENSION), "89");

        JSONObject vcard = new JSONObject();
        vcard.put(StringUtils.capitalize(VCardAddMap.COUNTRY), "Россия");
        vcard.put(StringUtils.capitalize(VCardAddMap.CITY), "Санкт-Петербург");
        vcard.put(StringUtils.capitalize(VCardAddMap.COMPANY_NAME), "Питер-сити");
        vcard.put(StringUtils.capitalize(VCardAddMap.WORK_TIME), "0;3;10;0;18;0;4;6;10;0;11;0");
        vcard.put(StringUtils.capitalize(VCardAddMap.PHONE), phone);

        return vcard;
    }
}
