package ru.yandex.autotests.directapi.vcards.add;

import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.vcards.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by chicos on 22.07.14.
 */
@Aqua.Test
@Features(VCardsFeatures.ADD)
@Tag(TagDictionary.TRUNK)
public class AddVCardsMultipleTest {
    private static LogSteps log = LogSteps.getLogger(AddVCardsMultipleTest.class);

    private static final String singleClient = VCardsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3916")
    public void addMultipleVCardsInOneRequestTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);
        api.as(singleClient);
        Long campaignID1 = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
        Long campaignID2 = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);

        VCardAddMap firstItem = new VCardAddMap().defaultContacts()
                .withCampaignId(campaignID1);
        VCardAddMap secondItem = new VCardAddMap().defaultContacts()
                .withCompanyName("Потрясающая кампания №2")
                .withCampaignId(campaignID1);
        VCardAddMap thirdItem = new VCardAddMap().defaultContacts()
                .withCompanyName("Потрясающая кампания №3")
                .withCampaignId(campaignID2);

        List<Long> cardIds = api.userSteps.vCardsSteps().vCardsAdd(firstItem, secondItem, thirdItem);

        assertThat("Неожиданный размер списка IDs добавленных визиток", cardIds, hasSize(3));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3917")
    public void sameVCardsForDifferentCampaignsTest() {
        api.as(singleClient);
        Long campaignID1 = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
        Long campaignID2 = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);

        VCardAddMap item1 = new VCardAddMap().defaultContacts().withCampaignId(campaignID1);
        VCardAddMap item2 = new VCardAddMap().defaultContacts().withCampaignId(campaignID2);

        List<Long> cardIds = api.as(singleClient).userSteps.vCardsSteps().vCardsAdd(item1, item2);

        assertThat("размер списка IDs добавленных визиток", cardIds, hasSize(2));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3918")
    public void differentVCardsForOneCampaignTest() {
        api.as(singleClient);
        Long campaignID1 = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);

        VCardAddMap item1 = new VCardAddMap().defaultContacts().withCampaignId(campaignID1);
        VCardAddMap item2 = new VCardAddMap().defaultContacts()
                .withCompanyName("Потрясающая кампания №2")
                .withCampaignId(campaignID1);

        List<Long> cardIds = api.as(singleClient).userSteps.vCardsSteps().vCardsAdd(item1, item2);

        assertThat("размер списка IDs добавленных визиток", cardIds, hasSize(2));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3919")
    public void vCardsWithSuccessErrorTest() {
        api.as(singleClient);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
        long nonExistingCampaing = 9478374l;

        VCardAddMap firstItem = new VCardAddMap().defaultContacts()
                .withCampaignId(nonExistingCampaing);
        VCardAddMap secondItem = new VCardAddMap().defaultContacts()
                .withCampaignId(campaignID);

        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap()
                        .withVCards(firstItem, secondItem),
                ExpectedResult
                        .errors(new Notification(8800, Api5ErrorDetailsJava.CAMPAIGN_IN_DETAILS, nonExistingCampaing)),
                ExpectedResult.success()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3920")
    public void vCardsWithSuccessErrorWarningTest() {
        api.as(singleClient);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
        long nonExistingCampaign = 9478374L;

        VCardAddMap firstItem = new VCardAddMap().defaultContacts()
                .withCampaignId(nonExistingCampaign);
        VCardAddMap secondItem = new VCardAddMap().defaultContacts()
                .withCampaignId(campaignID);
        VCardAddMap thirdItem = new VCardAddMap().defaultContacts()
                .withCompanyName("Потрясающая кампания №1")
                .withCampaignId(campaignID);

        api.as(singleClient);
        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap()
                        .withVCards(firstItem, secondItem, secondItem, thirdItem),
                ExpectedResult
                        .errors(new Notification(8800, Api5ErrorDetailsJava.CAMPAIGN_IN_DETAILS, nonExistingCampaign)),
                ExpectedResult.success(),
                ExpectedResult.warnings(new Notification(10100)),
                ExpectedResult.success()
        );
    }
}
