package ru.yandex.autotests.directapi.vcards.add;

import java.util.Arrays;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.errors.Path;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.vcards.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.PhoneMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 09.12.14.
 */
@Aqua.Test
@Features(VCardsFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@Stories(ApiStories.JSON5)
public class AddVCardsNegativeJsonTest {
    private static LogSteps log = LogSteps.getLogger(AddVCardsNegativeJsonTest.class);

    private static final String singleClient = VCardsLogins.SINGLE_CLIENT;
    private static Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().protocol(ProtocolType.JSON);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void prepareCampaign() {
        api.as(singleClient).protocol(ProtocolType.JSON);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3921")
    public void invalidActionNameTest() {
        JSONObject vcard = getShortContacts();
        vcard.put(StringUtils.capitalize(VCardAddMap.CAMPAIGN_ID), campaignId);

        JSONObject request = new JSONObject();
        request.put("VCards", Arrays.asList(vcard));

        api.userSteps.vCardsSteps().shouldGetVCardErrorJsonOn(
                Action.ACTION_INVALID,
                request,
                new Api5Error(55, Api5ErrorDetailsJava.OPERATION_IS_NOT_SET)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3922")
    public void integerValueAsStringTest() {
        JSONObject vcard = getShortContacts();
        vcard.put(StringUtils.capitalize(VCardAddMap.CAMPAIGN_ID), String.valueOf(campaignId));

        JSONObject request = new JSONObject();
        request.put("VCards", Arrays.asList(vcard));

        api.userSteps.vCardsSteps().shouldGetResultOnJson(
                Action.ADD,
                null,
                request,
                ExpectedResult.success()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3923")
    public void stringValueAsIntegerTest() {
        JSONObject vcard = getShortContacts();
        vcard.put(StringUtils.capitalize(VCardAddMap.CAMPAIGN_ID), campaignId);
        vcard.put(StringUtils.capitalize(VCardAddMap.CITY), 123456);

        JSONObject request = new JSONObject();
        request.put("VCards", Arrays.asList(vcard));

        api.userSteps.vCardsSteps().shouldGetResultOnJson(
                Action.ADD,
                null,
                request,
                ExpectedResult.success()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3924")
    public void emptyActionNameTest() {
        JSONObject vcard = getShortContacts();
        vcard.put(StringUtils.capitalize(VCardAddMap.CAMPAIGN_ID), campaignId);

        JSONObject request = new JSONObject();
        request.put("VCards", Arrays.asList(vcard));

        api.userSteps.vCardsSteps().shouldGetVCardErrorJsonOn(
                Action.ACTION_EMPTY,
                request,
                new Api5Error(55, Api5ErrorDetailsJava.OPERATION_IS_NOT_SET)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3925")
    public void noVCardParamsTest() {
        JSONObject request = new JSONObject();
        api.userSteps.vCardsSteps().shouldGetVCardErrorJsonOn(
                Action.ADD,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        Path.path(AddRequestMap.VCARDS)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3926")
    public void integerArrayInVCardsTest() {
        List<Integer> invalid = Arrays.asList(123, 456, 789);
        JSONObject request = new JSONObject();
        request.put("VCards", invalid);

        api.userSteps.vCardsSteps().shouldGetVCardErrorJsonOn(
                Action.ADD,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.INVALID_VALUE,
                        Path.path(AddRequestMap.VCARDS)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3927")
    public void stringInVCardsTest() {
        String invalid = "someString";
        JSONObject request = new JSONObject();
        request.put("VCards", invalid);

        api.userSteps.vCardsSteps().shouldGetVCardErrorJsonOn(
                Action.ADD,
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                        StringUtils.capitalize(AddRequestMap.VCARDS)));
    }

    private JSONObject getShortContacts() {
        JSONObject phone = new JSONObject();
        phone.put(StringUtils.capitalize(PhoneMap.COUNTRY_CODE), "+7");
        phone.put(StringUtils.capitalize(PhoneMap.CITY_CODE), "812");
        phone.put(StringUtils.capitalize(PhoneMap.PHONE_NUMBER), "123-45-67");
        phone.put(StringUtils.capitalize(PhoneMap.EXTENSION), "89");

        JSONObject vcard = new JSONObject();
        vcard.put(StringUtils.capitalize(VCardAddMap.COUNTRY), "Россия");
        vcard.put(StringUtils.capitalize(VCardAddMap.CITY), "Санкт-Петербург");
        vcard.put(StringUtils.capitalize(VCardAddMap.COMPANY_NAME), "Питер-сити");
        vcard.put(StringUtils.capitalize(VCardAddMap.WORK_TIME), "0;3;10;0;18;0;4;6;10;0;11;0");
        vcard.put(StringUtils.capitalize(VCardAddMap.PHONE), phone);

        return vcard;
    }
}
