package ru.yandex.autotests.directapi.vcards.add;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.vcards.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.MapPointMap;
import ru.yandex.autotests.directapi.model.api5.vcards.PhoneMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.model.banners.PointOnMapMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by chicos on 02.06.15.
 */
@Aqua.Test
@Features(VCardsFeatures.ADD)
public class AddVCardsNegativeSoapTest {
    private static LogSteps log = LogSteps.getLogger(AddVCardsNegativeSoapTest.class);

    private static final String singleClient = VCardsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().protocol(ProtocolType.SOAP).as(singleClient);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3929")
    public void emptyVCardsPackTest() {
        api.userSteps.vCardsSteps().shouldGetVCardErrorOn(
                Action.ADD,
                new AddRequestMap(),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(AddRequestMap.VCARDS))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3928")
    public void noRequiredFieldCountryTest() {
        api.userSteps.vCardsSteps().shouldGetVCardErrorOn(
                Action.ADD,
                new AddRequestMap()
                        .withVCards(new VCardAddMap()
                                .shortContacts()
                                .withCountry(null)),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        path(AddRequestMap.VCARDS), path(VCardAddMap.COUNTRY))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3930")
    public void noRequiredFieldCityCodeTest() {
        api.userSteps.vCardsSteps().shouldGetVCardErrorOn(
                Action.ADD,
                new AddRequestMap()
                        .withVCards(new VCardAddMap()
                                .shortContacts()
                                .withPhone(new PhoneMap()
                                        .defaultPhone()
                                        .withCityCode(null))),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_VALUE_OR_NULL,
                        path(AddRequestMap.VCARDS, VCardAddMap.PHONE, PhoneMap.CITY_CODE))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3931")
    public void noRequiredFieldMapPointCoordinateTest() {
        api.userSteps.vCardsSteps().shouldGetVCardErrorOn(
                Action.ADD,
                new AddRequestMap()
                        .withVCards(new VCardAddMap()
                                .shortContacts()
                                .withPointOnMap(new MapPointMap()
                                        .withX(45.733604f)
                                        .withY(45.724312f))
                        ),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_VALUE_OR_NULL,
                        path(AddRequestMap.VCARDS, VCardAddMap.POINT_ON_MAP, PointOnMapMap.X_1))
        );
    }
}
